/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BeamData {
    private final ByteOffset offset;
    private final int duration;
    private final int color;
    private final ItemStack stack;
    private final boolean fade;
    private final boolean reversed;
    private int ticksLived = 0;
    public static final StreamCodec<RegistryFriendlyByteBuf, BeamData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, BeamData>(){

        public BeamData decode(RegistryFriendlyByteBuf buf) {
            ByteOffset offset = (ByteOffset)ByteOffset.STREAM_CODEC.decode((Object)buf);
            int duration = buf.readVarInt();
            int color = buf.readInt();
            ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return !stack.isEmpty() ? new BeamData(offset, duration, color, stack, buf.readBoolean(), buf.readBoolean()) : new BeamData(offset, duration, color, stack, false, false);
        }

        public void encode(RegistryFriendlyByteBuf buf, BeamData beamData) {
            ByteOffset.STREAM_CODEC.encode((Object)buf, (Object)beamData.offset);
            buf.writeVarInt(beamData.duration);
            buf.writeInt(beamData.color);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)beamData.stack);
            if (!beamData.stack.isEmpty()) {
                buf.writeBoolean(beamData.fade);
                buf.writeBoolean(beamData.reversed);
            }
        }
    };

    public BeamData(ByteOffset offset, int duration, int color, ItemStack stack, boolean fade, boolean reversed) {
        this.offset = offset;
        this.duration = duration;
        this.color = color;
        this.stack = stack;
        this.fade = fade;
        this.reversed = reversed;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public boolean fade() {
        return this.fade;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BeamData that = (BeamData)obj;
        return Objects.equals(this.offset, that.offset) && this.duration == that.duration && this.color == that.color && ItemStack.matches((ItemStack)this.stack, (ItemStack)that.stack) && this.fade == that.fade && this.reversed == that.reversed;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.duration, this.color, ItemStack.hashItemAndComponents((ItemStack)this.stack), this.fade, this.reversed);
    }

    public String toString() {
        return "BeamData[offset=" + String.valueOf(this.offset) + ", duration=" + this.duration + ", color=" + this.color + ", stack=" + String.valueOf(this.stack) + ", fade=" + this.fade + ", reversed=" + this.reversed + "]";
    }

    public Vec3 getStart(Vec3 basePos) {
        return this.reversed ? this.offset.offset(basePos) : basePos;
    }

    public Vec3 getEnd(Vec3 basePos) {
        return this.reversed ? basePos : this.offset.offset(basePos);
    }

    public AABB getAABB(BlockPos basePos) {
        Vec3 vec = Vec3.atCenterOf((Vec3i)basePos);
        return new AABB(this.getStart(vec), this.getEnd(vec));
    }

    public float getProgress(float partialTicks) {
        return Mth.clamp((float)(((float)(this.ticksLived - 1) + partialTicks) / (float)this.duration), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        ++this.ticksLived;
    }

    public boolean isExpired() {
        return this.ticksLived > this.duration;
    }

    public int[] getRGB() {
        int[] res = new int[]{this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF};
        return res;
    }

    public record ByteOffset(byte x, byte y, byte z) {
        public static final StreamCodec<ByteBuf, ByteOffset> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ByteOffset::x, (StreamCodec)ByteBufCodecs.BYTE, ByteOffset::y, (StreamCodec)ByteBufCodecs.BYTE, ByteOffset::z, ByteOffset::new);

        public Vec3 offset(Vec3 from) {
            return from.add((double)this.x, (double)this.y, (double)this.z);
        }
    }

    public static class Builder {
        private final BlockPos src;
        private final BlockPos dest;
        private final int duration;
        private final int color;
        private ItemStack stack = ItemStack.EMPTY;
        private boolean fade = false;
        private boolean reversed = false;

        public Builder(ModularRouterBlockEntity router, BlockPos dest, int color) {
            this(router.getBlockPos(), dest, router.getTickRate(), color);
        }

        public Builder(BlockPos src, BlockPos dest, int duration, int color) {
            this.src = src;
            this.dest = dest;
            this.duration = duration;
            this.color = color;
        }

        public Builder withItemStack(ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public Builder fade(boolean fade) {
            this.fade = fade;
            return this;
        }

        public Builder reversed(boolean reversed) {
            this.reversed = reversed;
            return this;
        }

        public BeamData build() {
            ByteOffset offset = new ByteOffset((byte)Mth.clamp((int)(this.dest.getX() - this.src.getX()), (int)-128, (int)127), (byte)Mth.clamp((int)(this.dest.getY() - this.src.getY()), (int)-128, (int)127), (byte)Mth.clamp((int)(this.dest.getZ() - this.src.getZ()), (int)-128, (int)127));
            return new BeamData(offset, this.duration, this.color, this.stack, this.fade, this.reversed);
        }
    }
}

