/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.desht.modularrouters.ModularRoutersTags;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModItemTagsProvider
extends ItemTagsProvider {
    public ModItemTagsProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, blockTagProvider, "modularrouters", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (DeferredHolder ro : ModItems.ITEMS.getEntries()) {
            if (ro.get() instanceof ModuleItem) {
                this.addItemsToTag(ModularRoutersTags.Items.MODULES, new Supplier[]{ro});
                continue;
            }
            if (ro.get() instanceof UpgradeItem) {
                this.addItemsToTag(ModularRoutersTags.Items.UPGRADES, new Supplier[]{ro});
                continue;
            }
            if (ro.get() instanceof AugmentItem) {
                this.addItemsToTag(ModularRoutersTags.Items.AUGMENTS, new Supplier[]{ro});
                continue;
            }
            if (!(ro.get() instanceof SmartFilterItem)) continue;
            this.addItemsToTag(ModularRoutersTags.Items.FILTERS, new Supplier[]{ro});
        }
        this.tag(ModularRoutersTags.Items.ACTIVATOR_BLACKLIST).addOptional(ResourceLocation.parse((String)"notenoughwands:acceleration_wand"));
    }

    @SafeVarargs
    private void addItemsToTag(TagKey<Item> tagKey, Supplier<? extends ItemLike> ... items) {
        this.tag(tagKey).add((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::asItem).toArray(Item[]::new)));
    }

    public String getName() {
        return "Modular Routers Item Tags";
    }
}

