/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class BulkItemFilterMenu
extends AbstractSmartFilterMenu {
    private static final int INV_START = 54;
    private static final int INV_END = 80;
    private static final int HOTBAR_START = 81;
    private static final int HOTBAR_END = 89;
    private static final int PLAYER_INV_X = 8;
    private static final int PLAYER_INV_Y = 151;
    private static final int PLAYER_HOTBAR_Y = 209;
    private final int currentSlot;
    private final BaseModuleHandler.BulkFilterHandler handler;

    public BulkItemFilterMenu(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer, MFLocator.fromNetwork(extraData));
    }

    public BulkItemFilterMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        super(ModMenuTypes.BULK_FILTER_MENU.get(), windowId, invPlayer, loc);
        int i;
        this.handler = new BaseModuleHandler.BulkFilterHandler(this.filterStack, this.router, loc.getModuleStack(invPlayer.player), loc.filterSlot(), !invPlayer.player.level().isClientSide);
        this.currentSlot = invPlayer.selected + 81;
        for (i = 0; i < this.handler.getSlots(); ++i) {
            this.addSlot((Slot)new FilterSlot((IItemHandler)this.handler, i, 8 + 18 * (i % 9), 19 + 18 * (i / 9)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, 151 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)invPlayer, i, 8 + i * 18, 209));
        }
    }

    public void clearSlots() {
        this.handler.runBatchOperation(() -> {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                this.handler.setStackInSlot(i, ItemStack.EMPTY);
            }
        });
        if (this.getRouter() != null && !this.getRouter().nonNullLevel().isClientSide) {
            this.getRouter().recompileNeeded(ModularRouterBlockEntity.RecompileFlag.MODULES);
        }
    }

    public void mergeInventory(IItemHandler srcInv, ModuleFlags flags, boolean clearFirst) {
        if (srcInv == null) {
            return;
        }
        SetofItemStack stacks = clearFirst ? new SetofItemStack(flags) : SetofItemStack.fromItemHandler((IItemHandler)this.handler, flags);
        int origSize = stacks.size();
        for (int i = 0; i < srcInv.getSlots() && stacks.size() < this.handler.getSlots(); ++i) {
            ItemStack stack = srcInv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack.copyWithCount(1));
        }
        this.handler.runBatchOperation(() -> {
            int slot = 0;
            for (ItemStack stack : stacks.sorted()) {
                this.handler.setStackInSlot(slot++, stack);
            }
            while (slot < this.handler.getSlots()) {
                this.handler.setStackInSlot(slot++, ItemStack.EMPTY);
            }
        });
        if (this.getRouter() != null && !this.getRouter().nonNullLevel().isClientSide) {
            this.getRouter().recompileNeeded(ModularRouterBlockEntity.RecompileFlag.MODULES);
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot srcSlot = (Slot)this.slots.get(index);
        if (srcSlot != null && srcSlot.hasItem()) {
            ItemStack stackInSlot = srcSlot.getItem();
            ItemStack stack = stackInSlot.copyWithCount(1);
            if (index < this.handler.getSlots()) {
                srcSlot.set(ItemStack.EMPTY);
            } else if (index >= this.handler.getSlots()) {
                ItemStack stack0;
                int freeSlot;
                for (freeSlot = 0; freeSlot < this.handler.getSlots() && !(stack0 = this.handler.getStackInSlot(freeSlot)).isEmpty() && !ItemStack.matches((ItemStack)stack0, (ItemStack)stack); ++freeSlot) {
                }
                if (freeSlot < this.handler.getSlots()) {
                    ((Slot)this.slots.get(freeSlot)).set(stack);
                    srcSlot.set(stackInSlot);
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.QUICK_CRAFT) {
            if (this.router == null && slot == this.currentSlot) {
                return;
            }
            if (slot < this.handler.getSlots() && slot >= 0) {
                ((Slot)this.slots.get(slot)).set(this.getCarried().isEmpty() ? ItemStack.EMPTY : this.getCarried().copyWithCount(1));
                return;
            }
        }
        if (slot < this.handler.getSlots() && slot >= 0) {
            return;
        }
        super.clicked(slot, dragType, clickTypeIn, player);
    }
}

