/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.compat.recipeviewers.rei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticateditemactions.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;

public class ReiClientCompat {
    public static void init() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ReiClientCompat::handleGuiKeyPress);
        eventBus.addListener(ReiClientCompat::handleGuiMouseKeyPress);
        ClientEventHandler.registerHoveredStackProvider(new ClientEventHandler.IHoveredStackProvider(){

            @Override
            public ItemStack getHoveredStack(Screen screen) {
                return ReiClientCompat.getStack();
            }

            @Override
            public boolean restockSingle(Screen screen) {
                return Minecraft.getInstance().screen instanceof AbstractDisplayViewingScreen;
            }

            @Override
            public boolean restockEmptySlot() {
                return true;
            }
        });
    }

    private static ItemStack getStack() {
        return REIRuntime.getInstance().getOverlay().flatMap(overlay -> {
            EntryStack focusedStack = overlay.getEntryList().getFocusedStack();
            if (!focusedStack.isEmpty()) {
                return Optional.of((ItemStack)focusedStack.castValue());
            }
            if (overlay.getFavoritesList().isPresent() && !(focusedStack = ((OverlayListWidget)overlay.getFavoritesList().get()).getFocusedStack()).isEmpty()) {
                return Optional.of((ItemStack)focusedStack.castValue());
            }
            return Optional.empty();
        }).orElseGet(ReiClientCompat::getRecipeViewStack);
    }

    private static ItemStack getRecipeViewStack() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof AbstractDisplayViewingScreen)) {
            return ItemStack.EMPTY;
        }
        AbstractDisplayViewingScreen displayScreen = (AbstractDisplayViewingScreen)screen;
        for (EntryWidget widget : Widgets.walk((Iterable)displayScreen.children(), EntryWidget.class::isInstance)) {
            if (!widget.containsMouse(PointHelper.ofMouse())) continue;
            EntryStack currentEntry = widget.getCurrentEntry();
            return currentEntry.isEmpty() ? ItemStack.EMPTY : (ItemStack)currentEntry.castValue();
        }
        return ItemStack.EMPTY;
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        ItemStack stack;
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && !(stack = ReiClientCompat.getStack()).isEmpty() && ReiClientCompat.tryHighlightItem(stack)) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        ItemStack stack;
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && !(stack = ReiClientCompat.getStack()).isEmpty() && ReiClientCompat.tryHighlightItem(stack)) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    private static boolean tryHighlightItem(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        HighlightHandler.highlightItem((Player)player, stack);
        return true;
    }
}

