/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.compat.recipeviewers.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticateditemactions.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;

public class JeiClientCompat {
    @Nullable
    private static IJeiRuntime runtime = null;

    public static void setRuntime(@Nullable IJeiRuntime runtime) {
        JeiClientCompat.runtime = runtime;
    }

    public static void init() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(JeiClientCompat::handleGuiKeyPress);
        eventBus.addListener(JeiClientCompat::handleGuiMouseKeyPress);
        ClientEventHandler.registerHoveredStackProvider(new ClientEventHandler.IHoveredStackProvider(){

            @Override
            public ItemStack getHoveredStack(Screen screen) {
                return JeiClientCompat.getStack().orElse(ItemStack.EMPTY);
            }

            @Override
            public boolean restockSingle(Screen screen) {
                return runtime != null && runtime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK).isPresent();
            }

            @Override
            public boolean restockEmptySlot() {
                return true;
            }
        });
    }

    private static Optional<ItemStack> getStack() {
        return runtime == null ? Optional.empty() : runtime.getIngredientListOverlay().getIngredientUnderMouse().or(() -> runtime.getBookmarkOverlay().getIngredientUnderMouse()).flatMap(ITypedIngredient::getItemStack).or(() -> runtime.getRecipesGui().getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK));
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        if (runtime == null) {
            return;
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && JeiClientCompat.getStack().map(JeiClientCompat::tryHighlightItem).orElse(false).booleanValue()) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    private static boolean tryHighlightItem(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        HighlightHandler.highlightItem((Player)player, stack);
        return true;
    }
}

