/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.compat.recipeviewers.emi;

import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.RecipeScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticateditemactions.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;

public class EmiClientCompat {
    public static void init() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(EmiClientCompat::handleGuiKeyPress);
        eventBus.addListener(EmiClientCompat::handleGuiMouseKeyPress);
        ClientEventHandler.registerHoveredStackProvider(new ClientEventHandler.IHoveredStackProvider(){

            @Override
            public ItemStack getHoveredStack(Screen screen) {
                return EmiClientCompat.getStack();
            }

            @Override
            public boolean restockSingle(Screen screen) {
                return Minecraft.getInstance().screen instanceof RecipeScreen;
            }

            @Override
            public boolean restockEmptySlot() {
                return true;
            }
        });
    }

    private static ItemStack getStack() {
        List emiStacks;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof RecipeScreen) {
            RecipeScreen recipeScreen = (RecipeScreen)screen;
            emiStacks = recipeScreen.getHoveredStack().getEmiStacks();
        } else {
            emiStacks = EmiApi.getHoveredStack((boolean)true).getStack().getEmiStacks();
        }
        return emiStacks.isEmpty() ? ItemStack.EMPTY : ((EmiStack)emiStacks.getFirst()).getItemStack();
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        ItemStack stack;
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && !(stack = EmiClientCompat.getStack()).isEmpty() && EmiClientCompat.tryHighlightItem(stack)) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        ItemStack stack;
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ClientEventHandler.ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && !(stack = EmiClientCompat.getStack()).isEmpty() && EmiClientCompat.tryHighlightItem(stack)) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    private static boolean tryHighlightItem(ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        HighlightHandler.highlightItem((Player)player, stack);
        return true;
    }
}

