/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticateditemactions.client.gui.ItemActionsTranslationHelper;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;
import net.p3pp3rf1y.sophisticateditemactions.network.DepositItemsPayload;
import net.p3pp3rf1y.sophisticateditemactions.network.RestockItemsPayload;
import net.p3pp3rf1y.sophisticateditemactions.network.SyncItemTransfersPayload;

public class ItemTransferHandler {
    public static final int INTERACTION_RANGE = 10;

    public static void depositMultipleItems(Player player, boolean mainInventory, boolean hotbar, boolean onlyMatching) {
        if (!mainInventory && !hotbar) {
            throw new IllegalArgumentException("At least one of mainInventory or hotbar must be true");
        }
        int minSlot = hotbar ? 0 : 9;
        int maxSlot = mainInventory ? 36 : 9;
        ItemTransferHandler.depositItem(player, minSlot, maxSlot, onlyMatching);
    }

    public static void depositItem(Player player, int itemSlot, boolean onlyMatching) {
        ItemTransferHandler.depositItem(player, itemSlot, itemSlot + 1, onlyMatching);
    }

    private static void depositItem(Player player, int minSlot, int maxSlot, boolean onlyMatching) {
        Map<ResourceLocation, List<BlockPos>> storages = ItemTransferHandler.getInteractionStoragePositionsAround(player);
        Map<ResourceLocation, List<Integer>> entities = ItemTransferHandler.getStorageEntitiesAround(player);
        if (!storages.isEmpty() || !entities.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DepositItemsPayload(minSlot, maxSlot, storages, entities, onlyMatching), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ItemTransferHandler.playError(player, ItemActionsTranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
        }
    }

    private static Map<ResourceLocation, List<BlockPos>> getInteractionStoragePositionsAround(Player player) {
        HashMap<ResourceLocation, Set> tempStorages = new HashMap<ResourceLocation, Set>();
        Level level = player.level();
        WorldHelper.getBlockEntitiesInRange((Level)level, (BlockPos)player.blockPosition(), (int)10).forEach(be -> ItemActionHandlerRegistry.getBlockHandlerFor(level, be.getBlockPos(), be, IBlockItemActionHandler.Action.DEPOSIT).ifPresent(handler -> {
            if (player.mayInteract(level, be.getBlockPos())) {
                tempStorages.computeIfAbsent(handler.id(), k -> new HashSet()).add(handler.getInteractionPosToActOn(be.getBlockPos(), (BlockEntity)be));
            }
        }));
        HashMap<ResourceLocation, List<BlockPos>> storages = new HashMap<ResourceLocation, List<BlockPos>>();
        tempStorages.forEach((key, value) -> storages.put((ResourceLocation)key, new ArrayList(value)));
        return storages;
    }

    private static Map<ResourceLocation, List<Integer>> getStorageEntitiesAround(Player player) {
        HashMap<ResourceLocation, List<Integer>> entities = new HashMap<ResourceLocation, List<Integer>>();
        player.level().getEntities((Entity)player, player.getBoundingBox().inflate(10.0), e -> e.distanceTo((Entity)player) <= 10.0f).forEach(e -> ItemActionHandlerRegistry.getEntityHandlerIdFor(e).ifPresent(id -> entities.computeIfAbsent((ResourceLocation)id, k -> new ArrayList()).add(e.getId())));
        return entities;
    }

    public static void handleDeposit(Player player, int minSlot, int maxSlot, Map<ResourceLocation, List<BlockPos>> storagePositions, Map<ResourceLocation, List<Integer>> entities, boolean onlyMatching) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        List<IDepositHandler> handlers = ItemTransferHandler.collectAndSortDepositHandlers(player, storagePositions, entities, serverPlayer);
        HashMap<Vec3, List<ItemStack>> inserted = new HashMap<Vec3, List<ItemStack>>();
        HashSet<Integer> depositedFromSlots = new HashSet<Integer>();
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            IDepositHandler depositHandler2;
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.isEmpty()) continue;
            ArrayList<IDepositHandler> followUpHandlers = new ArrayList<IDepositHandler>();
            ArrayList<IDepositHandler> followupEmptyHandlers = new ArrayList<IDepositHandler>();
            ItemStackKey stackKey = ItemStackKey.of((ItemStack)stack);
            for (IDepositHandler depositHandler2 : handlers) {
                ItemMatchResult match = depositHandler2.getItemMatch(stackKey);
                if (match == ItemMatchResult.MATCHING_STACK) {
                    if (!(stack = ItemTransferHandler.depositToHandlerAndLog(depositHandler2, stack, player, slot, inserted, depositedFromSlots)).isEmpty()) continue;
                    break;
                }
                if (match == ItemMatchResult.MATCHING_ITEM) {
                    followUpHandlers.add(depositHandler2);
                    continue;
                }
                if (onlyMatching || match != ItemMatchResult.NO_MATCH) continue;
                followupEmptyHandlers.add(depositHandler2);
            }
            followUpHandlers.addAll(followupEmptyHandlers);
            if (stack.isEmpty()) continue;
            Iterator<IDepositHandler> iterator = followUpHandlers.iterator();
            while (iterator.hasNext() && !(stack = ItemTransferHandler.depositToHandlerAndLog(depositHandler2 = iterator.next(), stack, player, slot, inserted, depositedFromSlots)).isEmpty()) {
            }
        }
        Vec3 playerPos = player.getEyePosition().add(0.0, -0.1, 0.0);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(inserted, playerPos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(inserted, playerPos, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ItemTransferHandler.showDepositMessage(player, minSlot, maxSlot, inserted, depositedFromSlots);
    }

    private static void showDepositMessage(Player player, int minSlot, int maxSlot, Map<Vec3, List<ItemStack>> inserted, Set<Integer> depositedFromSlots) {
        MutableComponent message;
        Level level = player.level();
        if (maxSlot - minSlot == 1) {
            if (inserted.isEmpty()) {
                message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_item", new Object[]{Component.literal((String)player.getInventory().getItem(minSlot).getHoverName().getString()).withStyle(ChatFormatting.RED)});
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
            } else {
                message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("deposited_item", new Object[]{Component.literal((String)inserted.values().iterator().next().iterator().next().getHoverName().getString()).withStyle(ChatFormatting.DARK_GREEN)});
            }
        } else if (inserted.isEmpty()) {
            message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_items", new Object[0]);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
        } else {
            message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("deposited_items", new Object[]{Component.literal((String)String.valueOf(depositedFromSlots.size())).withStyle(ChatFormatting.DARK_GREEN)});
        }
        player.displayClientMessage((Component)message, true);
    }

    private static List<IDepositHandler> collectAndSortDepositHandlers(Player player, Map<ResourceLocation, List<BlockPos>> storagePositions, Map<ResourceLocation, List<Integer>> entities, ServerPlayer serverPlayer) {
        ArrayList<IDepositHandler> handlers = new ArrayList<IDepositHandler>();
        storagePositions.forEach((handlerId, positions) -> ItemActionHandlerRegistry.getBlockHandler(handlerId).ifPresent(handler -> positions.forEach(pos -> {
            if (WorldHelper.playerMayInteract((Player)player, (BlockPos)pos)) {
                handler.getDepositHandler(serverPlayer, (BlockPos)pos).ifPresent(handlers::add);
            }
        })));
        entities.forEach((handlerId, entityIds) -> ItemActionHandlerRegistry.getEntityHandler(handlerId).ifPresent(handler -> entityIds.forEach(entityId -> {
            Entity entity = player.level().getEntity(entityId.intValue());
            if (entity == null) {
                return;
            }
            handler.getDepositHandler(entity).ifPresent(handlers::add);
        })));
        handlers.sort(Comparator.comparingDouble(h -> player.distanceToSqr(h.getPosition())));
        return handlers;
    }

    private static ItemStack depositToHandlerAndLog(IDepositHandler depositHandler, ItemStack stack, Player player, int slot, Map<Vec3, List<ItemStack>> inserted, Set<Integer> depositedFromSlots) {
        ItemStack remaining = depositHandler.insertItem(stack);
        if (remaining.getCount() < stack.getCount()) {
            inserted.computeIfAbsent(depositHandler.getPosition(), k -> new ArrayList()).add(stack.copyWithCount(stack.getCount() - remaining.getCount()));
            player.getInventory().setItem(slot, remaining);
            depositedFromSlots.add(slot);
            return remaining;
        }
        return stack;
    }

    public static void restockMultipleItems(Player player, ItemStack filter, boolean mainInventory, boolean hotbar, boolean fillEmpty, boolean refillSingle) {
        if (!mainInventory && !hotbar) {
            throw new IllegalArgumentException("At least one of mainInventory or hotbar must be true");
        }
        int minSlot = hotbar ? 0 : 9;
        int maxSlot = mainInventory ? 36 : 9;
        ItemTransferHandler.restockItem(player, filter, minSlot, maxSlot, fillEmpty, refillSingle);
    }

    public static void restockItem(Player player, ItemStack filter, int itemSlot, boolean fillEmpty, boolean refillSingle) {
        ItemStack item = player.getInventory().getItem(itemSlot);
        if (!fillEmpty && item.getCount() == item.getMaxStackSize()) {
            ItemTransferHandler.playError(player, ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_restock_full_stack", new Object[]{item.getHoverName().copy().setStyle(Style.EMPTY.withColor(0xFF5555))}));
            return;
        }
        ItemTransferHandler.restockItem(player, filter, itemSlot, itemSlot + 1, fillEmpty, refillSingle);
    }

    private static void restockItem(Player player, ItemStack filter, int minSlot, int maxSlot, boolean fillEmpty, boolean refillSingle) {
        if (maxSlot - minSlot > 1 && ItemTransferHandler.checkStacksDoNotAllowRestock(player, minSlot, maxSlot, fillEmpty)) {
            ItemTransferHandler.playError(player, ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_restock_full_stacks", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
            return;
        }
        Map<ResourceLocation, List<BlockPos>> storages = ItemTransferHandler.getInteractionStoragePositionsAround(player);
        Map<ResourceLocation, List<Integer>> entities = ItemTransferHandler.getStorageEntitiesAround(player);
        if (!storages.isEmpty() || !entities.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RestockItemsPayload(filter, minSlot, maxSlot, fillEmpty, refillSingle, storages, entities), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ItemTransferHandler.playError(player, ItemActionsTranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)));
        }
    }

    private static boolean checkStacksDoNotAllowRestock(Player player, int minSlot, int maxSlot, boolean fillEmpty) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if ((!fillEmpty || !stack.isEmpty()) && (stack.isEmpty() || stack.getCount() >= stack.getMaxStackSize())) continue;
            return false;
        }
        return true;
    }

    private static void playError(Player player, MutableComponent message) {
        player.displayClientMessage((Component)message, true);
        player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 0.45f + RandHelper.getRandomMinusOneToOne((RandomSource)player.level().random) * 0.1f);
    }

    public static void handleRestock(Player player, Map<ResourceLocation, List<BlockPos>> storagePositions, Map<ResourceLocation, List<Integer>> entities, int minSlot, int maxSlot, ItemStack filter, boolean fillEmpty, boolean refillSingle) {
        MutableComponent message;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        List<IRestockHandler> restockHandlers = ItemTransferHandler.collectAndSortRestockHandlers(player, storagePositions, entities, serverPlayer);
        HashMap<Vec3, List<ItemStack>> transferredItems = new HashMap<Vec3, List<ItemStack>>();
        HashSet<Integer> restockedPlayerSlots = new HashSet<Integer>();
        for (int playerInventorySlot = minSlot; playerInventorySlot < maxSlot; ++playerInventorySlot) {
            int countToRestock;
            ItemStack playerInventoryStack = player.getInventory().getItem(playerInventorySlot);
            if (fillEmpty && !filter.isEmpty()) {
                if (!playerInventoryStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)playerInventoryStack, (ItemStack)filter)) continue;
                countToRestock = refillSingle ? 1 : filter.getMaxStackSize() - playerInventoryStack.getCount();
                ItemTransferHandler.restockSlot(restockHandlers, filter, playerInventoryStack, transferredItems, restockedPlayerSlots, player, playerInventorySlot, countToRestock);
                continue;
            }
            if (playerInventoryStack.isEmpty()) continue;
            countToRestock = refillSingle ? 1 : playerInventoryStack.getMaxStackSize() - playerInventoryStack.getCount();
            ItemTransferHandler.restockSlot(restockHandlers, playerInventoryStack, playerInventoryStack, transferredItems, restockedPlayerSlots, player, playerInventorySlot, countToRestock);
        }
        Vec3 playerPos = player.getEyePosition().add(0.0, -0.3, 0.0);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(transferredItems, playerPos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(transferredItems, playerPos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Level level = player.level();
        if (maxSlot - minSlot == 1) {
            if (transferredItems.isEmpty()) {
                ItemStack item = fillEmpty ? filter : player.getInventory().getItem(minSlot);
                message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_restock_item", new Object[]{Component.literal((String)item.getHoverName().getString()).withStyle(ChatFormatting.RED)});
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
            } else {
                message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("restocked_item", new Object[]{Component.literal((String)((ItemStack)((List)transferredItems.values().iterator().next()).iterator().next()).getHoverName().getString()).withStyle(ChatFormatting.DARK_GREEN)});
            }
        } else if (transferredItems.isEmpty()) {
            message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("cannot_restock_items", new Object[0]);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
        } else {
            message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("restocked_items", new Object[]{Component.literal((String)String.valueOf(restockedPlayerSlots.size())).withStyle(ChatFormatting.DARK_GREEN)});
        }
        player.displayClientMessage((Component)message, true);
    }

    private static void restockSlot(List<IRestockHandler> restockHandlers, ItemStack filter, ItemStack playerInventoryStack, Map<Vec3, List<ItemStack>> restocked, Set<Integer> restockedPlayerSlots, Player player, int playerInventorySlot, int countToRestock) {
        if (playerInventoryStack.getCount() >= filter.getMaxStackSize()) {
            return;
        }
        ItemStack stackToExtract = filter.copyWithCount(countToRestock);
        int totalExtracted = 0;
        int originalCount = stackToExtract.getCount();
        for (IRestockHandler handler : restockHandlers) {
            ItemStack extracted = handler.extractItem(stackToExtract);
            if (!extracted.isEmpty()) {
                restocked.computeIfAbsent(handler.getPosition(), k -> new ArrayList()).add(extracted.copy());
                if (playerInventoryStack.isEmpty()) {
                    playerInventoryStack = extracted.copy();
                } else {
                    playerInventoryStack.grow(extracted.getCount());
                }
                player.getInventory().setItem(playerInventorySlot, playerInventoryStack);
                restockedPlayerSlots.add(playerInventorySlot);
                totalExtracted += extracted.getCount();
                stackToExtract = stackToExtract.copyWithCount(stackToExtract.getCount() - extracted.getCount());
            }
            if (totalExtracted < originalCount) continue;
            break;
        }
    }

    private static List<IRestockHandler> collectAndSortRestockHandlers(Player player, Map<ResourceLocation, List<BlockPos>> storagePositions, Map<ResourceLocation, List<Integer>> entities, ServerPlayer serverPlayer) {
        ArrayList<IRestockHandler> handlers = new ArrayList<IRestockHandler>();
        storagePositions.forEach((handlerId, positions) -> ItemActionHandlerRegistry.getBlockHandler(handlerId).ifPresent(handler -> positions.forEach(pos -> {
            if (WorldHelper.playerMayInteract((Player)player, (BlockPos)pos)) {
                handler.getRestockHandler(serverPlayer, (BlockPos)pos).ifPresent(handlers::add);
            }
        })));
        entities.forEach((handlerId, entityIds) -> ItemActionHandlerRegistry.getEntityHandler(handlerId).ifPresent(handler -> entityIds.forEach(entityId -> {
            Entity entity = player.level().getEntity(entityId.intValue());
            if (entity == null) {
                return;
            }
            handler.getRestockHandler(entity).ifPresent(handlers::add);
        })));
        handlers.sort(Comparator.comparingDouble(h -> player.distanceToSqr(h.getPosition())));
        return handlers;
    }
}

