/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;

public interface IBlockEntityItemActionHandler<T>
extends IBlockItemActionHandler {
    @Override
    default public boolean canActOn(Level level, BlockPos pos, BlockEntity blockEntity) {
        return this.getObjectClass().isInstance(blockEntity);
    }

    @Override
    default public BlockPos getInteractionPosToActOn(BlockPos pos, BlockEntity blockEntity) {
        return this.getObjectClass().isInstance(blockEntity) ? this.getDepositPosToActOn(pos, this.getObjectClass().cast(blockEntity)) : pos;
    }

    default public BlockPos getDepositPosToActOn(BlockPos pos, T blockEntity) {
        return pos;
    }

    @Override
    default public ItemMatchResult getItemMatch(ServerPlayer player, ItemStackKey stackKey, BlockPos pos, IBlockItemActionHandler.Action action) {
        return this.getFromBlockEntity(player, pos, be -> this.getItemMatch(stackKey, be, action)).orElse(ItemMatchResult.NO_MATCH);
    }

    default public <R> Optional<R> getFromBlockEntity(ServerPlayer player, BlockPos pos, Function<T, R> getter) {
        return WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)pos, this.getObjectClass()).map(getter);
    }

    @Override
    default public Optional<IDepositHandler> getDepositHandler(ServerPlayer player, BlockPos pos) {
        return this.getFromBlockEntity(player, pos, this::getDepositHandler);
    }

    public IDepositHandler getDepositHandler(T var1);

    @Override
    default public Optional<IRestockHandler> getRestockHandler(ServerPlayer player, BlockPos pos) {
        return this.getFromBlockEntity(player, pos, this::getRestockHandler);
    }

    public IRestockHandler getRestockHandler(T var1);

    public ItemMatchResult getItemMatch(ItemStackKey var1, T var2, IBlockItemActionHandler.Action var3);

    public Class<T> getObjectClass();
}

