/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticateditemactions.client.gui.ItemActionsTranslationHelper;
import net.p3pp3rf1y.sophisticateditemactions.client.render.EntityHighlightRenderer;
import net.p3pp3rf1y.sophisticateditemactions.client.render.ItemFlightAnimator;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemTransferHandler;

public class ClientEventHandler {
    private static final String KEYBIND_SOPHISTICATEDITEMACTIONS_CATEGORY = "key.category.sophisticateditemactions.main";
    public static final KeyMapping ITEM_HIGHLIGHT_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("item_highlight"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(59), "key.category.sophisticateditemactions.main");
    public static final KeyMapping ITEM_DEPOSIT_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("deposit_item"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(39), "key.category.sophisticateditemactions.main");
    public static final KeyMapping ITEM_RESTOCK_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("restock_item"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(92), "key.category.sophisticateditemactions.main");
    private static final List<IHoveredStackProvider> HOVERED_STACK_PROVIDERS = new ArrayList<IHoveredStackProvider>();
    private static final IHoveredStackProvider DEFAULT_HOVERED_STACK_PROVIDER = new IHoveredStackProvider(){

        @Override
        public ItemStack getHoveredStack(Screen screen) {
            AbstractContainerScreen containerScreen;
            Slot slotUnderMouse;
            if (screen instanceof AbstractContainerScreen && (slotUnderMouse = (containerScreen = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null) {
                return slotUnderMouse.getItem();
            }
            return ItemStack.EMPTY;
        }

        @Override
        public boolean restockSingle(Screen screen) {
            return false;
        }

        @Override
        public int getRestockSlot(Screen screen, Player player, ItemStack filter) {
            AbstractContainerScreen containerScreen;
            if (!(screen instanceof AbstractContainerScreen) || (containerScreen = (AbstractContainerScreen)screen).getSlotUnderMouse() == null) {
                return -1;
            }
            return containerScreen.getSlotUnderMouse().getSlotIndex();
        }
    };

    public static void registerHoveredStackProvider(IHoveredStackProvider provider) {
        HOVERED_STACK_PROVIDERS.add(provider);
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::handleKeyInput);
        eventBus.addListener(ClientEventHandler::onPostClientTick);
        eventBus.addListener(ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(ClientEventHandler::renderLevelStage);
    }

    private static void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        ItemFlightAnimator.render(event.getPoseStack(), partialTick, event.getCamera().getPosition());
        EntityHighlightRenderer.render(event.getPoseStack(), partialTick, event.getCamera().getPosition());
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ITEM_HIGHLIGHT_KEYBIND);
        event.register(ITEM_DEPOSIT_KEYBIND);
        event.register(ITEM_RESTOCK_KEYBIND);
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            event.getScreen().getMinecraft().setScreen(null);
            event.setCanceled(true);
        }
    }

    public static void onPostClientTick(ClientTickEvent.Post event) {
        if (ITEM_HIGHLIGHT_KEYBIND.consumeClick()) {
            ClientEventHandler.tryHighlightItem();
        }
    }

    private static boolean tryHighlightItem(@Nullable Slot slot) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (slot == null || player == null || slot.getItem().isEmpty()) {
            return false;
        }
        HighlightHandler.highlightItem((Player)player, slot.getItem());
        return true;
    }

    private static void tryHighlightItem() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.getMainHandItem().isEmpty()) {
            return;
        }
        HighlightHandler.highlightItem((Player)player, player.getMainHandItem());
    }

    public static void handleKeyInput(InputEvent.Key event) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null && screen.isFocused()) {
            return;
        }
        if (!ITEM_DEPOSIT_KEYBIND.isUnbound() && ITEM_DEPOSIT_KEYBIND.getKey().getValue() == event.getKey() && event.getAction() == 1) {
            ClientEventHandler.tryDepositItem(event);
        } else if (!ITEM_RESTOCK_KEYBIND.isUnbound() && ITEM_RESTOCK_KEYBIND.getKey().getValue() == event.getKey() && event.getAction() == 1) {
            ClientEventHandler.tryRestockItem(event);
        }
    }

    private static void tryRestockItem(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int mods = event.getModifiers();
        boolean mainInventory = (mods & 1) != 0;
        boolean hotbar = (mods & 4) != 0;
        boolean fillEmpty = (mods & 2) != 0;
        Screen screen = Minecraft.getInstance().screen;
        ItemStack filter = ItemStack.EMPTY;
        int slot = -1;
        boolean refillSingle = false;
        if (screen != null) {
            IHoveredStackProvider provider = ClientEventHandler.getHoveredStackProvider(screen);
            if (provider != null) {
                filter = provider.getHoveredStack(screen);
                slot = provider.getRestockSlot(screen, (Player)player, filter);
                fillEmpty |= provider.restockEmptySlot();
                refillSingle = provider.restockSingle(screen);
            }
        } else {
            filter = player.getMainHandItem();
            slot = player.getInventory().selected;
        }
        if (slot == -1) {
            return;
        }
        if (mainInventory || hotbar) {
            ItemTransferHandler.restockMultipleItems((Player)player, filter, mainInventory, hotbar, fillEmpty, refillSingle);
        } else {
            ItemTransferHandler.restockItem((Player)player, filter, slot, fillEmpty, refillSingle);
        }
    }

    @Nullable
    private static IHoveredStackProvider getHoveredStackProvider(Screen screen) {
        for (IHoveredStackProvider provider : HOVERED_STACK_PROVIDERS) {
            if (provider.getHoveredStack(screen).isEmpty()) continue;
            return provider;
        }
        if (screen instanceof AbstractContainerScreen) {
            return DEFAULT_HOVERED_STACK_PROVIDER;
        }
        return null;
    }

    private static void tryDepositItem(InputEvent.Key event) {
        boolean hotbar;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int mods = event.getModifiers();
        boolean mainInventory = (mods & 1) != 0;
        boolean onlyMatching = (mods & 2) == 0;
        boolean bl = hotbar = (mods & 4) != 0;
        if (mainInventory || hotbar) {
            ClientEventHandler.tryDepositMultipleItems((Player)player, mainInventory, hotbar, onlyMatching);
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null) {
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                ClientEventHandler.tryDepositItem((Player)player, containerScreen.getSlotUnderMouse(), onlyMatching);
            }
        } else {
            ClientEventHandler.tryDepositItem((Player)player, onlyMatching);
        }
    }

    private static void tryDepositMultipleItems(Player player, boolean mainInventory, boolean hotbar, boolean onlyMatching) {
        ItemTransferHandler.depositMultipleItems(player, mainInventory, hotbar, onlyMatching);
    }

    private static void tryDepositItem(Player player, boolean onlyMatching) {
        ItemStack item = player.getMainHandItem();
        if (!item.isEmpty()) {
            ItemTransferHandler.depositItem(player, player.getInventory().selected, onlyMatching);
        }
    }

    private static void tryDepositItem(Player player, @Nullable Slot slot, boolean onlyMatching) {
        if (slot == null || slot.getItem().isEmpty() || !(slot.container instanceof Inventory)) {
            return;
        }
        ItemTransferHandler.depositItem(player, slot.getSlotIndex(), onlyMatching);
    }

    public static interface IHoveredStackProvider {
        public ItemStack getHoveredStack(Screen var1);

        public boolean restockSingle(Screen var1);

        default public int getRestockSlot(Screen screen, Player player, ItemStack filter) {
            NonNullList items = player.getInventory().items;
            for (int slot = 0; slot < items.size(); ++slot) {
                ItemStack stack = (ItemStack)items.get(slot);
                if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
                return slot;
            }
            return player.getInventory().getFreeSlot();
        }

        default public boolean restockEmptySlot() {
            return false;
        }
    }

    private static class ItemHighlightKeyConflictContext
    implements IKeyConflictContext {
        public static final ItemHighlightKeyConflictContext INSTANCE = new ItemHighlightKeyConflictContext();

        private ItemHighlightKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.IN_GAME.isActive() && Minecraft.getInstance().player != null && !Minecraft.getInstance().player.getMainHandItem().isEmpty() || KeyConflictContext.GUI.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

