/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.hacking.secstation.SimulationController;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.UntouchableSlot;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import org.apache.commons.lang3.tuple.Pair;

public class SecurityStationHackingMenu
extends AbstractPneumaticCraftMenu<SecurityStationBlockEntity> {
    public static final int NODE_SPACING = 31;

    public SecurityStationHackingMenu(int i, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        this(i, playerInventory, SecurityStationHackingMenu.fromBytes(playerInventory.player, buffer));
    }

    public SecurityStationHackingMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.SECURITY_STATION_HACKING.get(), windowId, playerInventory, pos);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 5; ++j) {
                UntouchableSlot slot = (UntouchableSlot)this.addSlot((Slot)new UntouchableSlot(((SecurityStationBlockEntity)this.blockEntity).getItemHandler(), j + i * 5, 8 + j * 31, 22 + i * 31));
                slot.setEnabled(slot.hasItem());
            }
        }
    }

    private static BlockPos fromBytes(Player player, RegistryFriendlyByteBuf buffer) {
        BlockPos tilePos = buffer.readBlockPos();
        HackSimulation playerSimulation = (HackSimulation)HackSimulation.STREAM_CODEC.decode((Object)buffer);
        HackSimulation aiSimulation = (HackSimulation)HackSimulation.STREAM_CODEC.decode((Object)buffer);
        ArrayList<Pair> nodes = new ArrayList<Pair>();
        int nNodes = buffer.readVarInt();
        for (int i = 0; i < nNodes; ++i) {
            nodes.add(Pair.of((Object)buffer.readVarInt(), (Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer))));
        }
        boolean justTesting = buffer.readBoolean();
        return PneumaticCraftUtils.getBlockEntityAt((BlockGetter)player.level(), tilePos, SecurityStationBlockEntity.class).map(teSS -> {
            SimulationController controller = new SimulationController((SecurityStationBlockEntity)teSS, player, playerSimulation, aiSimulation, justTesting);
            nodes.forEach(node -> {
                controller.getSimulation(ISimulationController.HackingSide.PLAYER).addNode((Integer)node.getLeft(), (ItemStack)node.getRight());
                controller.getSimulation(ISimulationController.HackingSide.AI).addNode((Integer)node.getLeft(), (ItemStack)node.getRight());
            });
            teSS.setSimulationController(controller);
            return teSS.getBlockPos();
        }).orElse(null);
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player par1EntityPlayer, int par2) {
        return ItemStack.EMPTY;
    }
}

