/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Collection;
import java.util.Locale;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HeatUtil {
    private static final int COMPARATOR_MIN = 73;
    private static final int COMPARATOR_MAX = 473;

    public static TintColor getColourForTemperature(int temperature) {
        float s;
        int h;
        if (temperature < 273) {
            h = 180 + (300 - temperature) / 5;
            s = (float)(273 - temperature) / 273.0f;
        } else if (temperature < 323) {
            h = 360;
            s = 0.0f;
        } else if (temperature < 873) {
            h = (int)((float)(temperature - 323) / 550.0f * 30.0f);
            s = (float)(temperature - 323) / 550.0f;
        } else {
            h = 30 + (int)((float)(temperature - 873) / 1400.0f * 15.0f);
            s = 1.0f;
        }
        return TintColor.getHSBColor((float)h / 360.0f, s, 1.0f);
    }

    public static int getComparatorOutput(int temperature) {
        if ((temperature -= 200) < 73) {
            return 0;
        }
        if (temperature > 473) {
            return 15;
        }
        return (temperature - 73) * 16 / 400;
    }

    public static int getEfficiency(int temperature) {
        return Mth.clamp((int)((625 - temperature) / 3), (int)0, (int)100);
    }

    public static Component formatHeatString(int tempK) {
        return HeatUtil.formatHeatString(tempK - 273 + "\u00b0C");
    }

    public static Component formatHeatString(Direction face, int tempK) {
        return HeatUtil.formatHeatString(face, tempK - 273 + "\u00b0C");
    }

    public static Component formatHeatString(String temp) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature", new Object[0]).append(String.valueOf(ChatFormatting.WHITE) + temp).withStyle(ChatFormatting.GRAY);
    }

    public static Component formatHeatString(Direction face, String temp) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature." + face.toString().toLowerCase(Locale.ROOT), new Object[0]).append(String.valueOf(ChatFormatting.WHITE) + temp).withStyle(ChatFormatting.GRAY);
    }

    public static int countExposedFaces(Collection<? extends BlockEntity> teList) {
        int exposed = 0;
        for (BlockEntity blockEntity : teList) {
            for (Direction face : Direction.values()) {
                if (!blockEntity.getLevel().isEmptyBlock(blockEntity.getBlockPos().relative(face))) continue;
                ++exposed;
            }
        }
        return exposed;
    }
}

