/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetItemAssign
extends ProgWidget
implements IVariableSetWidget {
    public static final MapCodec<ProgWidgetItemAssign> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetItemAssign.baseParts(builder).and((App)Codec.STRING.optionalFieldOf("var", (Object)"").forGetter(ProgWidgetItemAssign::getVariable)).apply((Applicative)builder, ProgWidgetItemAssign::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetItemAssign> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProgWidgetItemAssign::getVariable, ProgWidgetItemAssign::new);
    private String variable;
    private DroneAIManager aiManager;

    private ProgWidgetItemAssign(ProgWidget.PositionFields pos, String variable) {
        super(pos);
        this.variable = variable;
    }

    public ProgWidgetItemAssign() {
        this(ProgWidget.PositionFields.DEFAULT, "");
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetItemAssign(this.getPosition(), this.variable);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public boolean hasBlacklist() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_ASSIGN;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        if (!this.variable.isEmpty()) {
            ProgWidgetItemFilter filter = (ProgWidgetItemFilter)this.getConnectedParameters()[0];
            this.aiManager.setItemStack(this.variable, filter != null ? filter.getFilter() : drone.getInv().getStackInSlot(0).copy());
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.ITEM_ASSIGN.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemAssign.settingVariable", this.variable));
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.varAsTextComponent(this.variable));
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetItemAssign that = (ProgWidgetItemAssign)o;
        return this.baseEquals(that) && Objects.equals(this.variable, that.variable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.variable);
    }
}

