/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.IRedstoneEmissionWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.math.NumberUtils;

public class ProgWidgetEmitRedstone
extends ProgWidget
implements IRedstoneEmissionWidget,
ISidedWidget {
    public static final MapCodec<ProgWidgetEmitRedstone> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetEmitRedstone.baseParts(builder).and((App)Codec.BYTE.xmap(ProgWidget::decodeSides, ProgWidget::encodeSides).optionalFieldOf("sides", (Object)ALL_SIDES).forGetter(ProgWidgetEmitRedstone::getSides)).apply((Applicative)builder, ProgWidgetEmitRedstone::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetEmitRedstone> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BYTE.map(ProgWidget::decodeSides, ProgWidget::encodeSides), ProgWidgetEmitRedstone::getSides, ProgWidgetEmitRedstone::new);
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};

    public ProgWidgetEmitRedstone(ProgWidget.PositionFields pos, boolean[] accessingSides) {
        super(pos);
        this.accessingSides = accessingSides;
    }

    public ProgWidgetEmitRedstone() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetEmitRedstone(this.getPosition(), Arrays.copyOf(this.accessingSides, this.accessingSides.length));
    }

    @Override
    public int getEmittingRedstone() {
        if (this.getConnectedParameters()[0] != null) {
            return NumberUtils.toInt((String)((ProgWidgetText)this.getConnectedParameters()[0]).string);
        }
        return 0;
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.EMIT_REDSTONE.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.affectingSides", new Object[0]));
        curTooltip.addAll(this.getExtraStringInfo());
    }

    @Override
    public List<Component> getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return Collections.singletonList(ALL_TEXT);
        }
        if (noSides) {
            return Collections.singletonList(NONE_TEXT);
        }
        List<String> l = Arrays.stream(DirectionUtil.VALUES).filter(side -> this.accessingSides[side.get3DDataValue()]).map(ClientUtils::translateDirection).toList();
        return Collections.singletonList(Component.literal((String)Strings.join(l, (String)", ")));
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EMIT_REDSTONE;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIEmitRedstone(drone, widget);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetEmitRedstone that = (ProgWidgetEmitRedstone)o;
        return this.baseEquals(that) && Objects.deepEquals(this.accessingSides, that.accessingSides);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), Arrays.hashCode(this.accessingSides));
    }

    private static class DroneAIEmitRedstone
    extends Goal {
        private final IProgWidget widget;
        private final IDrone drone;

        DroneAIEmitRedstone(IDrone drone, IProgWidget widget) {
            this.widget = widget;
            this.drone = drone;
        }

        public boolean canUse() {
            IProgWidget object = this.widget;
            if (object instanceof ISidedWidget) {
                ISidedWidget sided = (ISidedWidget)((Object)object);
                IProgWidget iProgWidget = this.widget;
                if (iProgWidget instanceof IRedstoneEmissionWidget) {
                    IRedstoneEmissionWidget rs = (IRedstoneEmissionWidget)((Object)iProgWidget);
                    for (Direction dir : DirectionUtil.VALUES) {
                        if (!sided.isSideSelected(dir)) continue;
                        this.drone.setEmittingRedstone(dir, rs.getEmittingRedstone());
                    }
                }
            }
            return false;
        }
    }
}

