/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.DisplayTableBlockEntity;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisplayTableBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final BooleanProperty NE = BooleanProperty.create((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.create((String)"se");
    private static final BooleanProperty SW = BooleanProperty.create((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.create((String)"nw");
    private static final VoxelShape TOP = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DisplayTableBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NE, (Comparable)Boolean.valueOf(false))).setValue((Property)NW, (Comparable)Boolean.valueOf(false))).setValue((Property)SE, (Comparable)Boolean.valueOf(false))).setValue((Property)NW, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NE, SW, SE, NW});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        boolean[] connected = this.getConnections((LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), state);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).setValue((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).setValue((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).setValue((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean[] connected = this.getConnections(worldIn, currentPos, stateIn);
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).setValue((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).setValue((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).setValue((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.getValue((Property)NE) != false ? 1 : 0) | ((Boolean)state.getValue((Property)SE) != false ? 2 : 0) | ((Boolean)state.getValue((Property)SW) != false ? 4 : 0) | ((Boolean)state.getValue((Property)NW) != false ? 8 : 0);
        VoxelShape[] shapeCache = this.getShapeCache();
        if (shapeCache[shapeIdx] == null) {
            VoxelShape shape = this.adjustShapeForHeight(TOP);
            for (Leg leg : Leg.values()) {
                if (((Boolean)state.getValue((Property)leg.prop)).booleanValue()) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.adjustShapeForHeight(leg.shape));
            }
            shapeCache[shapeIdx] = shape.optimize();
        }
        return shapeCache[shapeIdx];
    }

    private VoxelShape adjustShapeForHeight(VoxelShape shape) {
        AABB aabb = shape.bounds();
        return Shapes.box((double)aabb.minX, (double)Math.max(0.0, aabb.minY - (1.0 - this.getTableHeight())), (double)aabb.minZ, (double)aabb.maxX, (double)(aabb.maxY - (1.0 - this.getTableHeight())), (double)aabb.maxZ);
    }

    public double getTableHeight() {
        return 1.0;
    }

    protected VoxelShape[] getShapeCache() {
        return SHAPE_CACHE;
    }

    protected boolean shelfLegs() {
        return false;
    }

    private boolean[] getConnections(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos below = pos.below();
        if (this.shelfLegs() && !world.getBlockState(below).isFaceSturdy((BlockGetter)world, below, Direction.UP)) {
            return new boolean[]{true, true, true, true};
        }
        boolean connE = this.isMatch(world, pos, state, Direction.EAST);
        boolean connW = this.isMatch(world, pos, state, Direction.WEST);
        boolean connS = this.isMatch(world, pos, state, Direction.SOUTH);
        boolean connN = this.isMatch(world, pos, state, Direction.NORTH);
        boolean[] res = new boolean[4];
        res[Leg.SE.ordinal()] = connE || connS;
        res[Leg.NE.ordinal()] = connE || connN;
        res[Leg.SW.ordinal()] = connW || connS;
        res[Leg.NW.ordinal()] = connW || connN;
        return res;
    }

    private boolean isMatch(LevelAccessor world, BlockPos pos, BlockState state, Direction dir) {
        BlockState state2 = world.getBlockState(pos.relative(dir));
        return state2.getBlock() == this && this.getRotation(state) == this.getRotation(state2);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getCachedShape(state);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te = world.getBlockEntity(pos);
        if (player.isShiftKeyDown() || te instanceof MenuProvider || ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            return super.useItemOn(heldStack, state, world, pos, player, hand, brtr);
        }
        if (te instanceof DisplayTableBlockEntity) {
            DisplayTableBlockEntity teDT = (DisplayTableBlockEntity)te;
            if (!world.isClientSide) {
                if (teDT.getItemHandler().getStackInSlot(0).isEmpty()) {
                    ItemStack excess = teDT.getItemHandler().insertItem(0, player.getItemInHand(hand), false);
                    if (!player.isCreative()) {
                        player.setItemInHand(hand, excess);
                    }
                } else {
                    ItemStack stack = teDT.getItemHandler().extractItem(0, 64, false);
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, world, (double)pos.getX() + 0.5, (double)pos.getY() + this.getTableHeight() + 0.1, (double)pos.getZ() + 0.5);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new DisplayTableBlockEntity(pPos, pState);
    }

    private static enum Leg {
        NE(1, -1, NE, Stream.of(Block.box((double)14.0, (double)11.5, (double)0.0, (double)15.0, (double)12.5, (double)3.0), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.box((double)13.5, (double)1.0, (double)0.5, (double)15.5, (double)8.0, (double)2.5), Block.box((double)13.25, (double)7.0, (double)0.25, (double)15.75, (double)13.0, (double)2.75), Block.box((double)13.0, (double)11.5, (double)1.0, (double)16.0, (double)12.5, (double)2.0), Block.box((double)14.0, (double)7.5, (double)0.0, (double)15.0, (double)8.5, (double)3.0), Block.box((double)13.0, (double)7.5, (double)1.0, (double)16.0, (double)8.5, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        SE(1, 1, SE, Stream.of(Block.box((double)13.0, (double)11.5, (double)14.0, (double)16.0, (double)12.5, (double)15.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)13.5, (double)1.0, (double)13.5, (double)15.5, (double)8.0, (double)15.5), Block.box((double)13.25, (double)7.0, (double)13.25, (double)15.75, (double)13.0, (double)15.75), Block.box((double)14.0, (double)11.5, (double)13.0, (double)15.0, (double)12.5, (double)16.0), Block.box((double)13.0, (double)7.5, (double)14.0, (double)16.0, (double)8.5, (double)15.0), Block.box((double)14.0, (double)7.5, (double)13.0, (double)15.0, (double)8.5, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        SW(-1, 1, SW, Stream.of(Block.box((double)1.0, (double)11.5, (double)13.0, (double)2.0, (double)12.5, (double)16.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)16.0), Block.box((double)0.5, (double)1.0, (double)13.5, (double)2.5, (double)8.0, (double)15.5), Block.box((double)0.25, (double)7.0, (double)13.25, (double)2.75, (double)13.0, (double)15.75), Block.box((double)0.0, (double)11.5, (double)14.0, (double)3.0, (double)12.5, (double)15.0), Block.box((double)1.0, (double)7.5, (double)13.0, (double)2.0, (double)8.5, (double)16.0), Block.box((double)0.0, (double)7.5, (double)14.0, (double)3.0, (double)8.5, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()),
        NW(-1, -1, NW, Stream.of(Block.box((double)0.0, (double)11.5, (double)1.0, (double)3.0, (double)12.5, (double)2.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)3.0), Block.box((double)0.5, (double)1.0, (double)0.5, (double)2.5, (double)8.0, (double)2.5), Block.box((double)0.25, (double)7.0, (double)0.25, (double)2.75, (double)13.0, (double)2.75), Block.box((double)1.0, (double)11.5, (double)0.0, (double)2.0, (double)12.5, (double)3.0), Block.box((double)0.0, (double)7.5, (double)1.0, (double)3.0, (double)8.5, (double)2.0), Block.box((double)1.0, (double)7.5, (double)0.0, (double)2.0, (double)8.5, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get());

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Leg(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }

    public static class Shelf
    extends DisplayTableBlock {
        private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];

        public Shelf(BlockBehaviour.Properties props) {
            super(props);
        }

        @Override
        public double getTableHeight() {
            return 0.5;
        }

        @Override
        protected VoxelShape[] getShapeCache() {
            return SHAPE_CACHE;
        }

        @Override
        protected boolean shelfLegs() {
            return true;
        }
    }
}

