/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.drone.debug;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record DroneDebugEntry(int progWidgetIndex, String message, Optional<BlockPos> pos, long receivedTime) {
    public static final StreamCodec<FriendlyByteBuf, DroneDebugEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DroneDebugEntry::progWidgetIndex, (StreamCodec)ByteBufCodecs.STRING_UTF8, DroneDebugEntry::message, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), DroneDebugEntry::pos, DroneDebugEntry::createClient);

    private static DroneDebugEntry createClient(int progWidgetIndex, String message, Optional<BlockPos> pos) {
        return new DroneDebugEntry(progWidgetIndex, message, pos, System.currentTimeMillis());
    }

    public static DroneDebugEntry create(String message, BlockPos pos, int progWidgetIndex) {
        return new DroneDebugEntry(progWidgetIndex, message, Optional.ofNullable(pos), 0L);
    }

    public boolean hasPos() {
        return this.pos.isPresent();
    }

    public BlockPos getPos() {
        return this.pos.orElse(null);
    }
}

