/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.autocrafting.advancedautocrafter;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

final class TaskSnapshotPersistence {
    private static final String AMOUNT = "amount";
    private static final String INPUTS = "inputs";
    private static final String ORIGINAL_ITERATIONS_REMAINING = "originalIterationsRemaining";
    private static final String ITERATIONS_REMAINING = "iterationsRemaining";
    private static final String EXPECTED_OUTPUTS = "expectedOutputs";
    private static final String ITERATIONS_RECEIVED = "iterationsReceived";
    private static final String ITERATIONS_TO_SEND_TO_SINK = "iterationsToSendToSink";
    private static final String INTERCEPTED_ANYTHING_SINCE_LAST_STEP = "interceptedAnythingSinceLastStep";
    private static final String LAST_SINK_RESULT = "lastSinkResult";
    private static final String LAST_SINK_RESULT_KEY_NAME = "lastSinkResultKeyName";
    private static final String LAST_SINK_RESULT_KEY_STACK = "lastSinkResultKeyStack";
    private static final String PATTERN_MAP_KEY = "k";
    private static final String PATTERN_MAP_VALUE = "v";
    private static final String SIMULATED_ITERATION_INPUTS = "simulatedIterationInputs";
    private static final String ORIGINAL_ITERATIONS_TO_SEND_TO_SINK = "originalIterationsToSendToSink";
    private static final String PATTERN_TYPE = "type";
    private static final String INGREDIENTS = "ingredients";
    private static final String OUTPUTS = "outputs";
    private static final String BYPRODUCTS = "byproducts";
    private static final String ID = "id";
    private static final String EXTERNAL_PATTERN = "externalPattern";
    private static final String INTERNAL_PATTERN = "internalPattern";
    private static final String INTERNAL = "internal";
    private static final String ROOT = "root";
    private static final String PATTERN = "pattern";
    private static final String RESOURCE = "resource";
    private static final String ACTOR = "actor";
    private static final String NOTIFY_ACTOR = "notifyActor";
    private static final String START_TIME = "startTime";
    private static final String INITIAL_REQUIREMENTS = "initialRequirements";
    private static final String INTERNAL_STORAGE = "internalStorage";
    private static final String CANCELLED = "cancelled";
    private static final String TASK_STATE = "state";
    private static final String COMPLETED_PATTERNS = "completedPatterns";
    private static final String PATTERNS = "patterns";

    private TaskSnapshotPersistence() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CompoundTag encodeSnapshot(TaskSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(ID, snapshot.id().id());
        CompoundTag resourceTag = TaskSnapshotPersistence.encodeResource(snapshot.resource());
        tag.put(RESOURCE, (Tag)resourceTag);
        tag.putLong(AMOUNT, snapshot.amount());
        Actor actor = snapshot.actor();
        if (actor instanceof PlayerActor) {
            String name;
            PlayerActor playerActor = (PlayerActor)actor;
            try {
                String string;
                name = string = playerActor.name();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            tag.putString(ACTOR, name);
        }
        tag.putBoolean(NOTIFY_ACTOR, snapshot.notifyActor());
        tag.putLong(START_TIME, snapshot.startTime());
        tag.put(INITIAL_REQUIREMENTS, (Tag)TaskSnapshotPersistence.encodeResourceList(snapshot.initialRequirements()));
        tag.put(INTERNAL_STORAGE, (Tag)TaskSnapshotPersistence.encodeResourceList(snapshot.internalStorage()));
        tag.putBoolean(CANCELLED, snapshot.cancelled());
        tag.putString(TASK_STATE, snapshot.state().name());
        ListTag completedPatterns = new ListTag();
        snapshot.completedPatterns().forEach(pattern -> completedPatterns.add((Object)TaskSnapshotPersistence.encodePatternSnapshot(pattern)));
        tag.put(COMPLETED_PATTERNS, (Tag)completedPatterns);
        tag.put(PATTERNS, (Tag)TaskSnapshotPersistence.encodePatternMap(snapshot.patterns()));
        return tag;
    }

    private static ListTag encodeResourceList(ResourceList list) {
        ListTag listTag = new ListTag();
        list.getAll().forEach(resource -> {
            CompoundTag entryTag = TaskSnapshotPersistence.encodeResource(resource);
            entryTag.putLong(AMOUNT, list.get(resource));
            listTag.add((Object)entryTag);
        });
        return listTag;
    }

    private static CompoundTag encodePattern(Pattern pattern) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(ID, pattern.id());
        ListTag ingredients = new ListTag();
        for (Object ingredient : pattern.layout().ingredients()) {
            ingredients.add((Object)TaskSnapshotPersistence.encodeIngredient((Ingredient)ingredient));
        }
        tag.put(INGREDIENTS, (Tag)ingredients);
        ListTag outputs = new ListTag();
        for (ResourceAmount output : pattern.layout().outputs()) {
            outputs.add((Object)((Tag)ResourceCodecs.AMOUNT_CODEC.encode((Object)output, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        }
        tag.put(OUTPUTS, (Tag)outputs);
        ListTag byproducts = new ListTag();
        for (ResourceAmount byproduct : pattern.layout().byproducts()) {
            byproducts.add((Object)((Tag)ResourceCodecs.AMOUNT_CODEC.encode((Object)byproduct, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        }
        tag.put(BYPRODUCTS, (Tag)byproducts);
        tag.putString(PATTERN_TYPE, pattern.layout().type().name());
        return tag;
    }

    private static CompoundTag encodePatternSnapshot(TaskSnapshot.PatternSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(ROOT, snapshot.root());
        tag.put(PATTERN, (Tag)TaskSnapshotPersistence.encodePattern(snapshot.pattern()));
        tag.put(INGREDIENTS, (Tag)TaskSnapshotPersistence.encodeIngredientMap(snapshot.ingredients()));
        boolean internal = snapshot.internalPattern() != null;
        tag.putBoolean(INTERNAL, internal);
        if (snapshot.internalPattern() != null) {
            tag.put(INTERNAL_PATTERN, (Tag)TaskSnapshotPersistence.encodeInternalPattern(snapshot.internalPattern()));
        } else if (snapshot.externalPattern() != null) {
            tag.put(EXTERNAL_PATTERN, (Tag)TaskSnapshotPersistence.encodeExternalPattern(snapshot.externalPattern()));
        }
        return tag;
    }

    private static ListTag encodePatternMap(Map<Pattern, TaskSnapshot.PatternSnapshot> patterns) {
        ListTag patternMap = new ListTag();
        for (Map.Entry<Pattern, TaskSnapshot.PatternSnapshot> pattern : patterns.entrySet()) {
            CompoundTag patternTag = new CompoundTag();
            patternTag.put(PATTERN_MAP_KEY, (Tag)TaskSnapshotPersistence.encodePattern(pattern.getKey()));
            patternTag.put(PATTERN_MAP_VALUE, (Tag)TaskSnapshotPersistence.encodePatternSnapshot(pattern.getValue()));
            patternMap.add((Object)patternTag);
        }
        return patternMap;
    }

    private static CompoundTag encodeInternalPattern(TaskSnapshot.InternalPatternSnapshot internalPattern) {
        CompoundTag tag = new CompoundTag();
        tag.putLong(ORIGINAL_ITERATIONS_REMAINING, internalPattern.originalIterationsRemaining());
        tag.putLong(ITERATIONS_REMAINING, internalPattern.iterationsRemaining());
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CompoundTag encodeExternalPattern(TaskSnapshot.ExternalPatternSnapshot externalPattern) {
        String name;
        String string;
        ExternalPatternSinkKey lastSinkResultKey;
        CompoundTag tag = new CompoundTag();
        tag.put(EXPECTED_OUTPUTS, (Tag)TaskSnapshotPersistence.encodeResourceList(externalPattern.expectedOutputs()));
        tag.put(SIMULATED_ITERATION_INPUTS, (Tag)TaskSnapshotPersistence.encodeResourceList(externalPattern.simulatedIterationInputs()));
        tag.putLong(ORIGINAL_ITERATIONS_TO_SEND_TO_SINK, externalPattern.originalIterationsToSendToSink());
        tag.putLong(ITERATIONS_TO_SEND_TO_SINK, externalPattern.iterationsToSendToSink());
        tag.putLong(ITERATIONS_RECEIVED, externalPattern.iterationsReceived());
        tag.putBoolean(INTERCEPTED_ANYTHING_SINCE_LAST_STEP, externalPattern.interceptedAnythingSinceLastStep());
        if (externalPattern.lastSinkResult() != null) {
            tag.putString(LAST_SINK_RESULT, externalPattern.lastSinkResult().name());
        }
        if (!((lastSinkResultKey = externalPattern.lastSinkResultKey()) instanceof InWorldExternalPatternSinkKey)) return tag;
        InWorldExternalPatternSinkKey inWorldExternalPatternSinkKey = (InWorldExternalPatternSinkKey)lastSinkResultKey;
        try {
            name = string = inWorldExternalPatternSinkKey.name();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String stack = string = inWorldExternalPatternSinkKey.stack();
        tag.putString(LAST_SINK_RESULT_KEY_NAME, name);
        tag.put(LAST_SINK_RESULT_KEY_STACK, (Tag)ItemStack.CODEC.encode((Object)stack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        return tag;
    }

    private static ListTag encodeIngredientMap(Map<Integer, Map<ResourceKey, Long>> ingredients) {
        ListTag ingredientMap = new ListTag();
        for (Map.Entry<Integer, Map<ResourceKey, Long>> ingredient : ingredients.entrySet()) {
            CompoundTag ingredientTag = new CompoundTag();
            ingredientTag.putInt("i", ingredient.getKey().intValue());
            ingredientTag.put(PATTERN_MAP_VALUE, (Tag)TaskSnapshotPersistence.encodeIngredientResources(ingredient));
            ingredientMap.add((Object)ingredientTag);
        }
        return ingredientMap;
    }

    private static ListTag encodeIngredientResources(Map.Entry<Integer, Map<ResourceKey, Long>> ingredient) {
        ListTag ingredientResources = new ListTag();
        for (Map.Entry<ResourceKey, Long> resourceAndAmount : ingredient.getValue().entrySet()) {
            CompoundTag tag = TaskSnapshotPersistence.encodeResource(resourceAndAmount.getKey());
            tag.putLong(AMOUNT, resourceAndAmount.getValue().longValue());
            ingredientResources.add((Object)tag);
        }
        return ingredientResources;
    }

    private static CompoundTag encodeResource(ResourceKey resource) {
        return (CompoundTag)ResourceCodecs.CODEC.encode((Object)((PlatformResourceKey)resource), (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow();
    }

    private static CompoundTag encodeIngredient(Ingredient ingredient) {
        CompoundTag ingredientTag = new CompoundTag();
        ingredientTag.putLong(AMOUNT, ingredient.amount());
        ListTag inputsTag = new ListTag();
        for (ResourceKey input : ingredient.inputs()) {
            inputsTag.add((Object)TaskSnapshotPersistence.encodeResource(input));
        }
        ingredientTag.put(INPUTS, (Tag)inputsTag);
        return ingredientTag;
    }

    static TaskSnapshot decodeSnapshot(CompoundTag tag) {
        UUID id = tag.getUUID(ID);
        ResourceKey resource = TaskSnapshotPersistence.decodeResource(tag.getCompound(RESOURCE));
        long amount = tag.getLong(AMOUNT);
        Actor actor = tag.contains(ACTOR, 8) ? new PlayerActor(tag.getString(ACTOR)) : Actor.EMPTY;
        boolean notifyActor = tag.getBoolean(NOTIFY_ACTOR);
        long startTime = tag.getLong(START_TIME);
        ResourceList initialRequirements = TaskSnapshotPersistence.decodeResourceList(tag.getList(INITIAL_REQUIREMENTS, 10));
        ResourceList internalStorage = TaskSnapshotPersistence.decodeResourceList(tag.getList(INTERNAL_STORAGE, 10));
        boolean cancelled = tag.getBoolean(CANCELLED);
        TaskState state = TaskState.valueOf((String)tag.getString(TASK_STATE));
        ArrayList<TaskSnapshot.PatternSnapshot> completedPatterns = new ArrayList<TaskSnapshot.PatternSnapshot>();
        for (Tag completedTag : tag.getList(COMPLETED_PATTERNS, 10)) {
            completedPatterns.add(TaskSnapshotPersistence.decodePatternSnapshot((CompoundTag)completedTag));
        }
        Map<Pattern, TaskSnapshot.PatternSnapshot> patterns = TaskSnapshotPersistence.decodePatternMap(tag.getList(PATTERNS, 10));
        return new TaskSnapshot(new TaskId(id), resource, amount, actor, notifyActor, startTime, patterns, completedPatterns, initialRequirements, internalStorage, state, cancelled);
    }

    private static ResourceList decodeResourceList(ListTag listTag) {
        MutableResourceListImpl resourceList = MutableResourceListImpl.create();
        for (Tag tag : listTag) {
            CompoundTag entryTag = (CompoundTag)tag;
            ResourceKey resource = TaskSnapshotPersistence.decodeResource(entryTag);
            long amount = entryTag.getLong(AMOUNT);
            resourceList.add(resource, amount);
        }
        return resourceList;
    }

    private static ResourceKey decodeResource(CompoundTag resourceTag) {
        return (ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)resourceTag).result().orElseThrow();
    }

    private static TaskSnapshot.PatternSnapshot decodePatternSnapshot(CompoundTag tag) {
        boolean root = tag.getBoolean(ROOT);
        Pattern pattern = TaskSnapshotPersistence.decodePattern(tag.getCompound(PATTERN));
        Map<Integer, Map<ResourceKey, Long>> ingredients = TaskSnapshotPersistence.decodeIngredientMap(tag.getList(INGREDIENTS, 10));
        if (tag.getBoolean(INTERNAL)) {
            TaskSnapshot.InternalPatternSnapshot internalPattern = TaskSnapshotPersistence.decodeInternalPattern(tag.getCompound(INTERNAL_PATTERN));
            return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, internalPattern, null);
        }
        TaskSnapshot.ExternalPatternSnapshot externalPattern = TaskSnapshotPersistence.decodeExternalPattern(tag.getCompound(EXTERNAL_PATTERN));
        return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, null, externalPattern);
    }

    private static Pattern decodePattern(CompoundTag tag) {
        UUID id = tag.getUUID(ID);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (Object ingredientTag : tag.getList(INGREDIENTS, 10)) {
            ingredients.add(TaskSnapshotPersistence.decodeIngredient((CompoundTag)ingredientTag));
        }
        ArrayList<ResourceAmount> outputs = new ArrayList<ResourceAmount>();
        for (Object outputTag : tag.getList(OUTPUTS, 10)) {
            outputs.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, outputTag).result().orElseThrow());
        }
        ArrayList<ResourceAmount> byproducts = new ArrayList<ResourceAmount>();
        for (Tag byproductTag : tag.getList(BYPRODUCTS, 10)) {
            byproducts.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)byproductTag).result().orElseThrow());
        }
        PatternType type = PatternType.valueOf((String)tag.getString(PATTERN_TYPE));
        if (type.equals((Object)PatternType.INTERNAL)) {
            return new Pattern(id, PatternLayout.internal(ingredients, outputs, byproducts));
        }
        if (type.equals((Object)PatternType.EXTERNAL)) {
            return new Pattern(id, PatternLayout.external(ingredients, outputs));
        }
        throw new IllegalStateException("Unknown pattern type: " + String.valueOf(type));
    }

    private static Ingredient decodeIngredient(CompoundTag tag) {
        long amount = tag.getLong(AMOUNT);
        ArrayList<ResourceKey> inputs = new ArrayList<ResourceKey>();
        for (Tag inputTag : tag.getList(INPUTS, 10)) {
            inputs.add(TaskSnapshotPersistence.decodeResource((CompoundTag)inputTag));
        }
        return new Ingredient(amount, inputs);
    }

    private static TaskSnapshot.InternalPatternSnapshot decodeInternalPattern(CompoundTag tag) {
        long originalIterationsRemaining = tag.getLong(ORIGINAL_ITERATIONS_REMAINING);
        long iterationsRemaining = tag.getLong(ITERATIONS_REMAINING);
        return new TaskSnapshot.InternalPatternSnapshot(originalIterationsRemaining, iterationsRemaining);
    }

    private static TaskSnapshot.ExternalPatternSnapshot decodeExternalPattern(CompoundTag tag) {
        ResourceList expectedOutputs = TaskSnapshotPersistence.decodeResourceList(tag.getList(EXPECTED_OUTPUTS, 10));
        ResourceList simulatedIterationInputs = TaskSnapshotPersistence.decodeResourceList(tag.getList(SIMULATED_ITERATION_INPUTS, 10));
        long originalIterationsToSendToSink = tag.getLong(ORIGINAL_ITERATIONS_TO_SEND_TO_SINK);
        long iterationsToSendToSink = tag.getLong(ITERATIONS_TO_SEND_TO_SINK);
        long iterationsReceived = tag.getLong(ITERATIONS_RECEIVED);
        boolean interceptedAnythingSinceLastStep = tag.getBoolean(INTERCEPTED_ANYTHING_SINCE_LAST_STEP);
        ExternalPatternSink.Result lastSinkResult = tag.contains(LAST_SINK_RESULT, 8) ? ExternalPatternSink.Result.valueOf((String)tag.getString(LAST_SINK_RESULT)) : null;
        InWorldExternalPatternSinkKey lastSinkResultKey = tag.contains(LAST_SINK_RESULT_KEY_NAME, 8) ? TaskSnapshotPersistence.decodeSinkResultKey(tag) : null;
        return new TaskSnapshot.ExternalPatternSnapshot(expectedOutputs, simulatedIterationInputs, originalIterationsToSendToSink, iterationsToSendToSink, iterationsReceived, interceptedAnythingSinceLastStep, lastSinkResult, (ExternalPatternSinkKey)lastSinkResultKey);
    }

    private static InWorldExternalPatternSinkKey decodeSinkResultKey(CompoundTag tag) {
        return new InWorldExternalPatternSinkKey(tag.getString(LAST_SINK_RESULT_KEY_NAME), (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(LAST_SINK_RESULT_KEY_STACK)).result().orElseThrow());
    }

    private static Map<Pattern, TaskSnapshot.PatternSnapshot> decodePatternMap(ListTag patternMapTag) {
        LinkedHashMap<Pattern, TaskSnapshot.PatternSnapshot> patternMap = new LinkedHashMap<Pattern, TaskSnapshot.PatternSnapshot>();
        for (Tag tag : patternMapTag) {
            CompoundTag entry = (CompoundTag)tag;
            Pattern key = TaskSnapshotPersistence.decodePattern(entry.getCompound(PATTERN_MAP_KEY));
            TaskSnapshot.PatternSnapshot value = TaskSnapshotPersistence.decodePatternSnapshot(entry.getCompound(PATTERN_MAP_VALUE));
            patternMap.put(key, value);
        }
        return patternMap;
    }

    private static Map<Integer, Map<ResourceKey, Long>> decodeIngredientMap(ListTag ingredientMapTag) {
        LinkedHashMap<Integer, Map<ResourceKey, Long>> ingredients = new LinkedHashMap<Integer, Map<ResourceKey, Long>>();
        for (Tag tag : ingredientMapTag) {
            CompoundTag entry = (CompoundTag)tag;
            int index = entry.getInt("i");
            Map<ResourceKey, Long> resources = TaskSnapshotPersistence.decodeIngredientResources(entry.getList(PATTERN_MAP_VALUE, 10));
            ingredients.put(index, resources);
        }
        return ingredients;
    }

    private static Map<ResourceKey, Long> decodeIngredientResources(ListTag ingredientResources) {
        LinkedHashMap<ResourceKey, Long> resources = new LinkedHashMap<ResourceKey, Long>();
        for (Tag rawTag : ingredientResources) {
            CompoundTag tag = (CompoundTag)rawTag;
            ResourceKey resource = TaskSnapshotPersistence.decodeResource(tag);
            long amount = tag.getLong(AMOUNT);
            resources.put(resource, amount);
        }
        return resources;
    }
}

