/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ToiletBlockEntity
extends BlockEntity
implements IFluidContainerBlock {
    protected final FluidContainer tank;

    public ToiletBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.TOILET.get(), pos, state);
    }

    public ToiletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.toilet.fluidCapacity.get(), container -> {
            this.setChanged();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public ItemInteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Vec3 hit = result.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
        if (hit.y() > 0.625 && !this.tank.isEmpty() && this.flushItems(player.level()).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.interactWithBottle(player, hand, this.worldPosition).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.performPlatformInteraction(player, hand, this.worldPosition, result.getDirection()).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.toilet.dispenseWater.get()).booleanValue() && result.getDirection() != Direction.DOWN) {
            if (this.tryAndFillWithFluid(this.level, this.worldPosition, (Fluid)Fluids.WATER, Vec3.atCenterOf((Vec3i)this.worldPosition)).consumesAction()) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.tryAndCreateObsidian(this.level, this.worldPosition, (Fluid)Fluids.WATER, Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0)).consumesAction()) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private InteractionResult flushItems(Level level) {
        List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition));
        if (!entities.isEmpty()) {
            if (!level.isClientSide()) {
                entities.forEach(entity -> {
                    Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageFlushItem(entity.getId(), this.worldPosition));
                    entity.discard();
                });
                level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 40);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tank.load(tag.getCompound("FluidTank"), provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag, provider);
        tag.put("FluidTank", (Tag)tankTag);
    }
}

