/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.infusion;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.PotionComponent;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.ChunkManager;

public class InfusionPylonTile
extends AbstractPylonTile {
    public InfusionPylonTile(BlockPos pos, BlockState state) {
        super(ModRegistry.INFUSION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.getItem() instanceof PotionFilterCard;
    }

    @Override
    public void removeChunkloads() {
        Level level;
        if (this.owner != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkManager.unloadChunk(this.owner, serverLevel, this.getBlockPos());
        }
    }

    @Override
    public void tick() {
        ServerPlayer player;
        MinecraftServer server;
        if (this.level != null && !this.level.isClientSide && this.canTick(60) && this.owner != null && (server = this.level.getServer()) != null && (player = server.getPlayerList().getPlayer(this.owner)) != null && player.isAffectedByPotions()) {
            ChunkManager.loadChunk(this.owner, (ServerLevel)this.level, this.getBlockPos());
            for (MobEffectInstance effect : this.getEffects()) {
                player.addEffect(effect);
            }
        }
    }

    public List<MobEffectInstance> getEffects() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            PotionComponent data;
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof PotionFilterCard) || !PotionFilterCard.isAllowed(stack) || PotionFilterCard.isBanned(stack) || (data = (PotionComponent)stack.get(ModRegistry.POTION_COMPONENT)) == null || data.duration() < PotionFilterCard.getRequiredDuration()) continue;
            int amplifier = Math.min(data.amplifier(), ConfigManager.SERVER.infusionMaximumPotency.getAsInt());
            effects.add(new MobEffectInstance(data.effect(), PotionFilterCard.getAppliedDuration(), amplifier, true, false));
        }
        return effects;
    }
}

