/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.base;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.compat.teams.TeamCompat;
import net.permutated.pylons.machines.base.AbstractPylonBlock;
import net.permutated.pylons.machines.base.PylonEnergyStorage;
import net.permutated.pylons.util.Range;

public abstract class AbstractPylonTile
extends BlockEntity {
    public static final int SLOTS = 9;
    public static final UUID NONE = new UUID(0L, 0L);
    protected final PylonEnergyStorage energyStorage;
    protected final ItemStackHandler itemStackHandler = new PylonItemStackHandler(9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractPylonTile.this.isItemValid(stack);
        }
    };
    protected int color = -1;
    protected UUID owner = NONE;
    private long lastTicked = 0L;
    int offset = 0;
    boolean enabled = true;
    protected final Range range = new Range(this.getRange());

    protected AbstractPylonTile(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        int buffer = ConfigManager.SERVER.harvesterPowerBuffer.getAsInt();
        this.energyStorage = new PylonEnergyStorage(() -> ((AbstractPylonTile)this).setChanged(), buffer, buffer);
    }

    protected abstract boolean isItemValid(ItemStack var1);

    protected boolean canAccessInventory() {
        return true;
    }

    protected boolean canAccessEnergy() {
        return false;
    }

    public static void registerItemCapability(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractPylonTile> blockEntityType) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (pylon, side) -> pylon.canAccessInventory() ? pylon.itemStackHandler : null);
    }

    public static void registerEnergyCapability(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractPylonTile> blockEntityType) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (pylon, side) -> pylon.canAccessEnergy() ? pylon.energyStorage : null);
    }

    public void dropItems() {
        AbstractPylonTile.dropItems(this.level, this.worldPosition, (IItemHandler)this.itemStackHandler);
    }

    public abstract void removeChunkloads();

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        if (this.color != newColor && this.level != null) {
            this.color = newColor;
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    public boolean hasTeamAccess(Player player) {
        return Boolean.TRUE.equals(ConfigManager.SERVER.teamSupportEnabled.get()) && TeamCompat.getInstance().arePlayersInSameTeam(this.owner, player.getUUID());
    }

    public boolean canAccess(Player player) {
        return Objects.equals(player.getUUID(), this.owner) || this.owner == NONE || player.hasPermissions(2) || this.hasTeamAccess(player);
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.level != null ? this.level.getGameTime() : 0L;
        if (this.offset(gameTime) % (long)every == 0L && gameTime != this.lastTicked && this.shouldWork()) {
            this.lastTicked = gameTime;
            return true;
        }
        return false;
    }

    protected long offset(long gameTime) {
        if (this.offset == 0) {
            this.offset += ThreadLocalRandom.current().nextInt(0, 20);
        }
        return gameTime + (long)this.offset;
    }

    public abstract void tick();

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        AbstractPylonTile pylonTile;
        if (blockEntity instanceof AbstractPylonTile && (pylonTile = (AbstractPylonTile)blockEntity).shouldWork()) {
            pylonTile.tick();
        }
    }

    protected static void dropItems(@Nullable Level world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.getCount() <= 0 || world == null) continue;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack);
        }
    }

    public String getOwnerName() {
        String lastKnown = this.owner == NONE ? null : UsernameCache.getLastKnownUsername((UUID)this.owner);
        return Objects.toString(lastKnown, "unknown");
    }

    public void updateContainer(FriendlyByteBuf packetBuffer) {
        String username = this.getOwnerName();
        packetBuffer.writeBlockPos(this.worldPosition);
        packetBuffer.writeInt(this.shouldWork() ? 1 : 0);
        packetBuffer.writeInt(this.getSelectedRange());
        packetBuffer.writeInt(username.length());
        packetBuffer.writeUtf(username);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inv", (Tag)this.itemStackHandler.serializeNBT(registries));
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.put("range", (Tag)this.range.serializeNBT());
        tag.putUUID("owner", this.owner);
        tag.putInt("color", this.color);
        tag.putBoolean("enabled", this.enabled);
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.itemStackHandler.deserializeNBT(registries, tag.getCompound("inv"));
        this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        this.range.deserializeNBT(tag.getCompound("range"));
        this.owner = tag.getUUID("owner");
        if (tag.contains("color")) {
            this.color = tag.getInt("color");
        }
        if (tag.contains("enabled")) {
            this.enabled = tag.getBoolean("enabled");
        }
        super.loadAdditional(tag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putUUID("owner", this.owner);
        tag.putInt("color", this.color);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        if (!tag.isEmpty()) {
            this.owner = tag.getUUID("owner");
            this.color = tag.getInt("color");
            super.handleUpdateTag(tag, lookupProvider);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
    }

    public boolean shouldWork() {
        return this.enabled && (Boolean)this.getBlockState().getValue((Property)AbstractPylonBlock.ENABLED) != false;
    }

    public void handleWorkPacket() {
        if (this.level != null) {
            boolean shouldWork;
            boolean bl = shouldWork = !this.shouldWork();
            if (this.enabled != shouldWork) {
                this.enabled = shouldWork;
                this.setChanged();
                if (!this.enabled) {
                    this.removeChunkloads();
                }
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }
    }

    protected byte[] getRange() {
        return new byte[]{1};
    }

    public int getSelectedRange() {
        return this.range.get();
    }

    public void handleRangePacket() {
        if (this.getRange().length > 1 && this.level != null) {
            this.range.next();
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public class PylonItemStackHandler
    extends ItemStackHandler {
        public PylonItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            AbstractPylonTile.this.setChanged();
        }
    }
}

