/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.machines.base.AbstractPylonTile;

@Mod(value="pylons", dist={Dist.CLIENT})
public class PylonsClient {
    public PylonsClient(IEventBus modEventBus, ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::onRegisterColorHandlersEvent);
    }

    public void onRegisterColorHandlersEvent(RegisterColorHandlersEvent.Block event) {
        event.register(this::getBlockColor, new Block[]{(Block)ModRegistry.EXPULSION_PYLON.get(), (Block)ModRegistry.INFUSION_PYLON.get(), (Block)ModRegistry.HARVESTER_PYLON.get(), (Block)ModRegistry.INTERDICTION_PYLON.get(), (Block)ModRegistry.PROTECTION_PYLON.get()});
    }

    public int getBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (level != null && pos != null && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractPylonTile) {
            AbstractPylonTile tile = (AbstractPylonTile)blockEntity;
            return tile.getColor();
        }
        return -1;
    }
}

