/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import github.nitespring.monsterplus.MonsterPlus;
import github.nitespring.monsterplus.config.CommonConfig;
import java.io.File;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    private static final ModConfigSpec.Builder common_builder = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder server_builder = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder client_builder = new ModConfigSpec.Builder();
    public static final ModConfigSpec common_config;
    public static final ModConfigSpec server_config;
    public static final ModConfigSpec client_config;
    public static final CommonConfig common;

    public static void loadConfig(ModConfigSpec config, String path) {
        MonsterPlus.LOGGER.info("Loading config" + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        MonsterPlus.LOGGER.info("Built config" + path);
        file.load();
        MonsterPlus.LOGGER.info("Loaded config" + path);
        config.correct((CommentedConfig)file);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)specPair.getLeft();
        common_config = (ModConfigSpec)specPair.getRight();
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

