/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item.scrolls;

import github.nitespring.monsterplus.common.entity.projectiles.CurseflameFireball;
import github.nitespring.monsterplus.common.item.scrolls.EnchantedScroll;
import github.nitespring.monsterplus.core.init.EntityInit;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CurseflameFireballSpellScroll
extends EnchantedScroll {
    public CurseflameFireballSpellScroll(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            this.doSpellB(player, player.getItemInHand(usedHand));
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
    }

    @Override
    public void doSpellA(Player playerIn, ItemStack item) {
        Vec3 pos = playerIn.position();
        Vec3 aim0 = playerIn.getLookAngle().normalize();
        float a = 0.09817477f;
        Vec3 aim = aim0.add((double)this.randomFloat(a), (double)this.randomFloat(a), (double)this.randomFloat(a));
        Vec3 posO = new Vec3(pos.x + 0.5 * aim0.x, pos.y + 1.4 + 0.5 * aim0.y, pos.z + 0.5 * aim0.z);
        this.throwFireball(10, posO, aim.scale((double)0.1f), 5.0f, playerIn);
        playerIn.getCooldowns().addCooldown((Item)this, 16);
        item.consume(1, (LivingEntity)playerIn);
        playerIn.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 0.5f, 0.75f);
    }

    @Override
    public void doSpellB(Player playerIn, ItemStack item) {
        Vec3 pos = playerIn.position();
        Vec3 aim0 = playerIn.getLookAngle().normalize();
        for (int i = 0; i < 3; ++i) {
            float a = 0.5235988f;
            Vec3 aim = aim0.add((double)this.randomFloat(a), (double)this.randomFloat(a), (double)this.randomFloat(a));
            Vec3 posO = new Vec3(pos.x + 0.5 * aim0.x, pos.y + 2.5 + 0.5 * aim0.y, pos.z + 0.5 * aim0.z);
            this.throwFireball(16, posO, aim.add(0.0, -0.25, 0.0).normalize().scale(0.25), 2.0f, playerIn);
        }
        playerIn.getCooldowns().addCooldown(item.getItem(), 3);
        item.consume(1, (LivingEntity)playerIn);
        playerIn.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 0.3f, 0.75f);
    }

    float randomFloat(float peak) {
        Random r = new Random();
        float f = r.nextFloat(-1.0f, 1.0f) * peak;
        return f;
    }

    private void throwFireball(int flyingTime, Vec3 pos, Vec3 aim, float damage, Player playerIn) {
        CurseflameFireball fireball = new CurseflameFireball((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.CURSEFLAME_FIREBALL.get()), playerIn.level());
        fireball.setPos(pos.x, pos.y, pos.z);
        fireball.setDeltaMovement(aim.x, aim.y, aim.z);
        fireball.setOwner((Entity)playerIn);
        fireball.setDamage(damage);
        playerIn.level().addFreshEntity((Entity)fireball);
        playerIn.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 0.5f, 0.75f);
    }
}

