/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item;

import github.nitespring.monsterplus.common.entity.projectiles.SkullProjectile;
import github.nitespring.monsterplus.common.item.ILeftClickSpecialActionItem;
import github.nitespring.monsterplus.core.enums.CustomItemTiers;
import github.nitespring.monsterplus.core.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SkullStaff
extends Item
implements ILeftClickSpecialActionItem {
    public SkullStaff(Item.Properties p) {
        super(p.attributes(SwordItem.createAttributes((Tier)CustomItemTiers.BONE, (int)1, (float)-2.8f)).durability(128).stacksTo(1).rarity(Rarity.EPIC));
    }

    public boolean isFoil(ItemStack i) {
        return super.isFoil(i);
    }

    @Override
    public void doLeftClickAction(Player playerIn, ItemStack item) {
        item.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
        this.shootSkull(playerIn, item);
    }

    public void shootSkull(Player playerIn, ItemStack item) {
        Level level = playerIn.level();
        Vec3 aim = playerIn.getLookAngle();
        Vec3 pos0 = playerIn.position().add(0.6 * aim.x, 1.6 + 0.6 * aim.y, 0.6 * aim.z);
        SkullProjectile skull = new SkullProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SPECTRAL_SKULL_PROJECTILE.get()), level);
        skull.setOwner((Entity)playerIn);
        skull.setPos(pos0);
        skull.setDeltaMovement((double)0.15f * aim.x, (double)0.15f * aim.y, (double)0.15f * aim.z);
        skull.setAttackDamage(6.0f);
        level.addFreshEntity((Entity)skull);
        level.playSound(null, BlockPos.containing((Position)pos0), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public boolean canAttackBlock(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return true;
    }
}

