/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item;

import github.nitespring.monsterplus.common.entity.projectiles.CrystalSpikes;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CrystalSword
extends SwordItem {
    public CrystalSword(Tier tier, Item.Properties properties) {
        super(tier, properties.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)3, (float)-2.4f)).stacksTo(1).rarity(Rarity.RARE));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity user) {
        double d = Math.sqrt((target.getX() - user.getX()) * (target.getX() - user.getX()) + (target.getY() - user.getY()) * (target.getY() - user.getY()) + (target.getZ() - user.getZ()) * (target.getZ() - user.getZ()));
        Vec3 aim = new Vec3((target.getX() - user.getX()) / d, (target.getY() - user.getY()) / d, (target.getZ() - user.getZ()) / d);
        for (int k = 1; k <= 2; ++k) {
            target.level().addFreshEntity((Entity)new CrystalSpikes(target.level(), 3.0f, target.position().x() + aim.x * (1.5 * (double)k - 1.0) + 0.5 * ((double)new Random().nextFloat() * 0.5 - 0.25), target.position().y(), target.position().z() + aim.z * (1.5 * (double)k - 1.0) + 0.5 * ((double)new Random().nextFloat() * 0.5 - 0.25), user.yHeadRot, 10 + k, user));
        }
        return super.hurtEnemy(stack, target, user);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        String string = "\u00a77\u00a7oSummons Crystal Spikes from the ground after hitting enemies";
        tooltip.add((Component)Component.literal((String)string));
    }
}

