/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.item;

import github.nitespring.monsterplus.ClientListener;
import github.nitespring.monsterplus.client.render.equipment.armour.CrystalArmourModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystalArmour
extends ArmorItem {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/armour/crystal_layer_1.png");

    public CrystalArmour(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.stacksTo(1).rarity(Rarity.EPIC).durability(512));
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return slot == EquipmentSlot.LEGS ? ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/armour/crystal_layer_2.png") : ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/armour/crystal_layer_1.png");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ArmorRender.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        String string = "\u00a77\u00a7o+15% Protection from Magic Damage";
        tooltip.add((Component)Component.literal((String)string));
    }

    private static final class ArmorRender
    implements IClientItemExtensions {
        private static final ArmorRender INSTANCE = new ArmorRender();

        private ArmorRender() {
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> model) {
            EntityModelSet models = Minecraft.getInstance().getEntityModels();
            ModelPart root = models.bakeLayer(slot == EquipmentSlot.LEGS ? ModelLayers.PLAYER_INNER_ARMOR : ClientListener.CRYSTAL_ARMOUR_MAIN_LAYER);
            ResourceLocation resource = slot == EquipmentSlot.LEGS ? ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/armour/crystal_layer_2.png") : ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/armour/crystal_layer_1.png");
            CrystalArmourModel aModel = new CrystalArmourModel(resource, root);
            return aModel;
        }
    }
}

