/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.util.CustomBlockTags;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class SorceressFireSpawner
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    private int warmupDelayTicks;
    private boolean sentFlameEvent;
    private float damage;
    public int rotationModifier;

    public SorceressFireSpawner(EntityType<? extends SorceressFireSpawner> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public SorceressFireSpawner(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn) {
        this((EntityType<? extends SorceressFireSpawner>)((EntityType)EntityInit.FLAME_SUMMONER.get()), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.setYRot(p_36930_ * 57.295776f);
        this.setPos(posX, posY, posZ);
        this.damage = damageIn;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
        this.warmupDelayTicks = p_20052_.getInt("Warmup");
        if (p_20052_.hasUUID("Owner")) {
            this.ownerUUID = p_20052_.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
        p_20139_.putInt("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            p_20139_.putUUID("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity e) {
        return new ClientboundAddEntityPacket((Entity)this, e);
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public float getAnimationProgress(float p_36937_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_36937_) / 20.0f;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    public boolean fireImmune() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double d1 = this.getY() + 0.05 + this.random.nextDouble();
                        double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double d3 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.025 + this.random.nextDouble() * 0.05;
                        double d5 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -4) {
                Vec3 pos = this.position();
                Level world = this.level();
                for (int i = -1; i <= 1; ++i) {
                    BlockPos blockPos = this.blockPosition().above(i);
                    if (this.level().getBlockState(blockPos).is(CustomBlockTags.FLAME_BREAKABLE)) {
                        this.level().destroyBlock(blockPos, true, (Entity)this.getOwner());
                        this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
                    }
                    if (!BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)blockPos, (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z))) continue;
                    BlockState blockstate = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockPos);
                    this.level().setBlock(blockPos, blockstate, 11);
                    this.level().gameEvent((Entity)this, (Holder)GameEvent.BLOCK_PLACE, blockPos);
                }
            }
            if (!this.sentFlameEvent) {
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
                this.sentFlameEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.discard();
            }
        }
    }

    public void handleEntityEvent(byte p_36935_) {
        super.handleEntityEvent(p_36935_);
        if (p_36935_ == 4) {
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.FIRECHARGE_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }
}

