/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import github.nitespring.monsterplus.core.init.EntityInit;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CrystalSpikes
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private float damage;
    public int xTilt;
    public int zTilt;
    public int rotationModifier;

    public CrystalSpikes(EntityType<? extends CrystalSpikes> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public CrystalSpikes(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn) {
        this((EntityType<? extends CrystalSpikes>)((EntityType)EntityInit.CRYSTAL_SPIKES.get()), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.setYRot(p_36930_ * 57.295776f);
        this.setPos(posX, posY, posZ);
        this.damage = damageIn;
    }

    public CrystalSpikes(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn, int xTilt, int zTilt) {
        this((EntityType<? extends CrystalSpikes>)((EntityType)EntityInit.CRYSTAL_SPIKES.get()), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.setYRot(p_36930_ * 57.295776f);
        this.setPos(posX, posY, posZ);
        this.damage = damageIn;
        this.xTilt = xTilt;
        this.zTilt = zTilt;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
        this.warmupDelayTicks = p_20052_.getInt("Warmup");
        if (p_20052_.hasUUID("Owner")) {
            this.ownerUUID = p_20052_.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
        p_20139_.putInt("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            p_20139_.putUUID("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity e) {
        return new ClientboundAddEntityPacket((Entity)this, e);
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public float getAnimationProgress(float p_36937_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_36937_) / 20.0f;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.xTilt = new Random().nextInt(30) - 14;
        this.zTilt = new Random().nextInt(30) - 14;
        this.setYRot(new Random().nextInt(360) + 1);
        this.rotationModifier = new Random().nextBoolean() ? (new Random().nextInt(2) + 1) / 2 : (new Random().nextInt(2) - 2) / 2;
    }

    public boolean fireImmune() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double d1 = this.getY() + 0.05 + this.random.nextDouble();
                        double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double d3 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.random.nextDouble() * 0.3;
                        double d5 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.level().addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -4) {
                for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.discard();
            }
        }
    }

    private void dealDamageTo(LivingEntity e) {
        LivingEntity livingentity = this.getOwner();
        if (e.isAlive() && !e.isInvulnerable() && e != livingentity) {
            if (livingentity == null) {
                e.hurt(this.level().damageSources().magic(), 6.0f);
                e.knockback((double)0.1f, 0.01, 0.01);
                Vec3 mov = e.getDeltaMovement();
                e.setDeltaMovement(mov.x, Math.max(mov.y + 0.5, -Math.min(mov.y, 0.0) + 0.5), mov.z);
            } else {
                if (livingentity.isAlliedTo((Entity)e)) {
                    return;
                }
                e.knockback((double)0.1f, 0.01, 0.01);
                Vec3 mov = e.getDeltaMovement();
                e.setDeltaMovement(mov.x, Math.max(mov.y + 0.5, -Math.min(mov.y, 0.0) + 0.5), mov.z);
                e.hurt(this.level().damageSources().indirectMagic((Entity)this, (Entity)livingentity), this.damage);
            }
        } else if (livingentity == e && e instanceof Player) {
            e.knockback((double)0.1f, 0.0, 0.0);
            Vec3 mov = e.getDeltaMovement();
            e.setDeltaMovement(mov.x, Math.max(mov.y + 0.5, -Math.min(mov.y, 0.0) + 0.5), mov.z);
        }
    }

    public void handleEntityEvent(byte p_36935_) {
        super.handleEntityEvent(p_36935_);
        if (p_36935_ == 4) {
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }
}

