/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import github.nitespring.monsterplus.common.entity.projectiles.CrystalSpikes;
import github.nitespring.monsterplus.core.init.ItemInit;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CrystalClump
extends AbstractHurtingProjectile
implements ItemSupplier {
    float damage = 8.0f;
    int livingTicks = 0;

    public CrystalClump(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public ItemStack getItem() {
        return ((Item)ItemInit.CRYSTAL_CLUMP.get()).getDefaultInstance();
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.PORTAL;
    }

    protected void onHitEntity(EntityHitResult p_37259_) {
        super.onHitEntity(p_37259_);
        p_37259_.getEntity().hurt(this.level().damageSources().indirectMagic(this.getOwner(), (Entity)this), 3.0f);
        this.createCrystals(Math.min(p_37259_.getEntity().getY(), this.getY() - 0.5), false);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        super.onHitBlock(p_37258_);
        this.createCrystals(this.getY() - 0.5, true);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    private void createCrystals(double y, boolean flag) {
        this.level().addFreshEntity((Entity)new CrystalSpikes(this.level(), this.damage, this.position().x, this.getY() - 0.5, this.position().z, this.yRotO, 0, (LivingEntity)this.getOwner()));
        for (int k = 0; k <= 9; ++k) {
            this.level().addFreshEntity((Entity)new CrystalSpikes(this.level(), this.damage, this.position().x + 4.5 * ((double)new Random().nextFloat() - 0.5), this.getY() - 0.5, this.position().z + 4.5 * ((double)new Random().nextFloat() - 0.5), this.yRotO + new Random().nextFloat(), new Random().nextInt(8), (LivingEntity)this.getOwner()));
        }
    }

    public void tick() {
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        ++this.livingTicks;
        if (this.livingTicks >= 3) {
            this.setDeltaMovement(vec3.x(), Math.max(vec3.y() - 0.1, -2.0), vec3.z());
        }
        this.accelerationPower *= (double)0.9f;
        super.tick();
    }
}

