/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.projectiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BloodySlashEntity
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 18;
    private float damage = 4.0f;
    private static final EntityDataAccessor<Integer> ANIMATIONSTATE = SynchedEntityData.defineId(BloodySlashEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BloodySlashEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public BloodySlashEntity(EntityType<?> p_19870_, Level p_19871_, Vec3 pos, float dmg, float rot) {
        this(p_19870_, p_19871_);
        this.setPos(pos);
        this.damage = dmg;
        this.setYRot(rot * 57.295776f);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATIONSTATE);
    }

    public void setAnimationState(int anim) {
        this.entityData.set(ANIMATIONSTATE, (Object)anim);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ANIMATIONSTATE, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
        if (p_20052_.hasUUID("Owner")) {
            this.ownerUUID = p_20052_.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
        if (this.ownerUUID != null) {
            p_20139_.putUUID("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.getCommandSenderWorld() instanceof ServerLevel && (entity = ((ServerLevel)this.getCommandSenderWorld()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity e) {
        return new ClientboundAddEntityPacket((Entity)this, e);
    }

    public boolean fireImmune() {
        return true;
    }

    public void tick() {
        super.tick();
        --this.lifeTicks;
        if (this.lifeTicks == 16 || this.lifeTicks == 14 || this.lifeTicks == 12) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 0.25f, this.random.nextFloat() * 0.2f + 1.0f, false);
            this.setAnimationState(this.getAnimationState() + 1);
        }
        if (this.lifeTicks == 8) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_SPLASH_HIGH_SPEED, this.getSoundSource(), 0.5f, this.random.nextFloat() * 0.2f + 2.85f, false);
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.15f, false);
            this.setAnimationState(this.getAnimationState() + 1);
            for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.2, 0.0, 1.2))) {
                this.dealDamageTo(livingentity);
            }
            for (int i = 0; i < 48; ++i) {
                double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                double d1 = this.getY() - 0.75 + this.random.nextDouble() * 1.5;
                double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                double d3 = (this.random.nextDouble() * 2.0 - 1.0) * 0.75;
                double d4 = 0.15 + this.random.nextDouble() * 0.6;
                double d5 = (this.random.nextDouble() * 2.0 - 1.0) * 0.75;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.NETHER_WART_BLOCK.defaultBlockState()), d0, d1 + 1.0, d2, d3, d4, d5);
            }
        }
        if (this.lifeTicks < 0) {
            this.discard();
        }
    }

    private void dealDamageTo(LivingEntity p_36945_) {
        LivingEntity livingentity = this.getOwner();
        if (p_36945_.isAlive() && !p_36945_.isInvulnerable() && p_36945_ != livingentity) {
            if (livingentity == null) {
                p_36945_.hurt(this.level().damageSources().generic(), this.damage);
            } else {
                if (livingentity.isAlliedTo((Entity)p_36945_)) {
                    return;
                }
                p_36945_.hurt(this.level().damageSources().mobAttack(livingentity), this.damage);
            }
        }
    }
}

