/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.ancienthero;

import github.nitespring.monsterplus.common.entity.ancienthero.AncientHero;
import github.nitespring.monsterplus.common.entity.projectiles.SkullProjectile;
import github.nitespring.monsterplus.core.init.EntityInit;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class AncientHeroSkull
extends FlyingMob
implements Enemy {
    Vec3 moveTargetPoint = Vec3.ZERO;
    BlockPos anchorPoint = BlockPos.ZERO;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    @Nullable
    Mob owner;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public AncientHeroSkull(EntityType<? extends AncientHeroSkull> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.xpReward = 10;
        this.moveControl = new EyeMoveControl((Mob)this);
        this.lookControl = new EyeLookControl(this, (Mob)this);
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob p_33995_) {
        this.owner = p_33995_;
    }

    public void setLimitedLife(int p_33988_) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = p_33988_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 50.0);
    }

    public void tick() {
        super.tick();
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new EyeAttackStrategyGoal());
        this.goalSelector.addGoal(2, (Goal)new EyeSweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new EyeCircleAroundAnchorGoal());
        this.targetSelector.addGoal(1, (Goal)new EyeAttackPlayerTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new CopyOwnerTargetGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected BodyRotationControl createBodyControl() {
        return new EyeBodyRotationControl((Mob)this);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 24 == 0) {
            this.shootSkull();
        }
    }

    public void shootSkull() {
        SkullProjectile skull = new SkullProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SPECTRAL_SKULL_PROJECTILE.get()), this.level());
        skull.setOwner((Entity)this);
        Vec3 aim = this.getLookAngle();
        if (this.getTarget() != null) {
            skull.setTarget(this.getTarget());
            aim = this.getTarget().position().add(this.position().scale(-1.0)).normalize();
        }
        skull.setAttackDamage(4.0f);
        Random rn = new Random();
        aim = aim.add((double)(1.75f * (rn.nextFloat() - 0.5f)), (double)(0.75f * (rn.nextFloat() - 0.5f)), (double)(1.75f * (rn.nextFloat() - 0.5f)));
        skull.setPos(this.position().add(1.5 * aim.x, 0.25 + 1.5 * aim.y, 1.5 * aim.z));
        skull.setDeltaMovement(aim.normalize().scale((double)0.05f));
        skull.accelerationPower = 0.05f;
        skull.setYRot(this.yHeadRot);
        this.level().addFreshEntity((Entity)skull);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_33126_, DifficultyInstance p_33127_, MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_) {
        this.anchorPoint = this.blockPosition().above(5);
        return super.finalizeSpawn(p_33126_, p_33127_, p_33128_, p_33129_);
    }

    public void readAdditionalSaveData(CompoundTag p_33132_) {
        super.readAdditionalSaveData(p_33132_);
        if (p_33132_.contains("AX")) {
            this.anchorPoint = new BlockPos(p_33132_.getInt("AX"), p_33132_.getInt("AY"), p_33132_.getInt("AZ"));
        }
    }

    public void addAdditionalSaveData(CompoundTag p_33141_) {
        super.addAdditionalSaveData(p_33141_);
        p_33141_.putInt("AX", this.anchorPoint.getX());
        p_33141_.putInt("AY", this.anchorPoint.getY());
        p_33141_.putInt("AZ", this.anchorPoint.getZ());
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean canAttackType(EntityType<?> p_33111_) {
        return true;
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (pEntity instanceof AncientHeroSkull || pEntity instanceof AncientHero) {
            return true;
        }
        if (this.getOwner() != null) {
            if (pEntity == this.owner) {
                return true;
            }
            return this.getOwner().isAlliedTo(pEntity);
        }
        return super.isAlliedTo(pEntity);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class EyeMoveControl
    extends MoveControl {
        private float speed;

        public EyeMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void tick() {
            if (AncientHeroSkull.this.horizontalCollision) {
                AncientHeroSkull.this.setYRot(AncientHeroSkull.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = AncientHeroSkull.this.moveTargetPoint.x - AncientHeroSkull.this.getX();
            double d1 = AncientHeroSkull.this.moveTargetPoint.y - AncientHeroSkull.this.getY();
            double d2 = AncientHeroSkull.this.moveTargetPoint.z - AncientHeroSkull.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = AncientHeroSkull.this.getYRot();
                float f1 = (float)Mth.atan2((double)d2, (double)d0);
                float f2 = Mth.wrapDegrees((float)(AncientHeroSkull.this.getYRot() + 90.0f));
                float f3 = Mth.wrapDegrees((float)(f1 * 57.295776f));
                AncientHeroSkull.this.setYRot(Mth.approachDegrees((float)f2, (float)f3, (float)4.0f) - 90.0f);
                AncientHeroSkull.this.yBodyRot = AncientHeroSkull.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs((float)f, (float)AncientHeroSkull.this.getYRot()) < 3.0f ? Mth.approach((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.approach((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.atan2((double)(-d1), (double)d3) * 57.2957763671875));
                AncientHeroSkull.this.setXRot(f4);
                float f5 = AncientHeroSkull.this.getYRot() + 90.0f;
                double d6 = (double)(this.speed * Mth.cos((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.sin((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.sin((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = AncientHeroSkull.this.getDeltaMovement();
                AncientHeroSkull.this.setDeltaMovement(vec3.add(new Vec3(d6, d8, d7).subtract(vec3).scale(0.2)));
            }
        }
    }

    class EyeLookControl
    extends LookControl {
        public EyeLookControl(AncientHeroSkull this$0, Mob p_33235_) {
            super(p_33235_);
        }

        public void tick() {
        }
    }

    class EyeAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        EyeAttackStrategyGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = AncientHeroSkull.this.getTarget();
            return livingentity != null ? AncientHeroSkull.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }

        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            AncientHeroSkull.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            AncientHeroSkull.this.anchorPoint = AncientHeroSkull.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, AncientHeroSkull.this.anchorPoint).above(10 + AncientHeroSkull.this.random.nextInt(20));
        }

        public void tick() {
            if (AncientHeroSkull.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    AncientHeroSkull.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + AncientHeroSkull.this.random.nextInt(4)) * 20);
                }
            }
        }

        private void setAnchorAboveTarget() {
            AncientHeroSkull.this.anchorPoint = AncientHeroSkull.this.getTarget().blockPosition().above(5 + AncientHeroSkull.this.random.nextInt(15));
        }
    }

    class EyeSweepAttackGoal
    extends EyeMoveTargetGoal {
        private boolean isScaredOfCat;
        private int catSearchTick;

        EyeSweepAttackGoal() {
        }

        public boolean canUse() {
            return AncientHeroSkull.this.getTarget() != null && AncientHeroSkull.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = AncientHeroSkull.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.isSpectator() || player.isCreative()) {
                    return false;
                }
            }
            if (!this.canUse()) {
                return false;
            }
            if (AncientHeroSkull.this.tickCount > this.catSearchTick) {
                this.catSearchTick = AncientHeroSkull.this.tickCount + 20;
                List list = AncientHeroSkull.this.level().getEntitiesOfClass(Cat.class, AncientHeroSkull.this.getBoundingBox().inflate(16.0), EntitySelector.ENTITY_STILL_ALIVE);
                for (Cat cat : list) {
                    cat.hiss();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void start() {
        }

        public void stop() {
            AncientHeroSkull.this.setTarget(null);
            AncientHeroSkull.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void tick() {
            LivingEntity livingentity = AncientHeroSkull.this.getTarget();
            if (livingentity != null) {
                AncientHeroSkull.this.moveTargetPoint = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
                if (AncientHeroSkull.this.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
                    AncientHeroSkull.this.doHurtTarget((Entity)livingentity);
                    AncientHeroSkull.this.attackPhase = AttackPhase.CIRCLE;
                    if (!AncientHeroSkull.this.isSilent()) {
                        AncientHeroSkull.this.level().levelEvent(1039, AncientHeroSkull.this.blockPosition(), 0);
                    }
                } else if (AncientHeroSkull.this.horizontalCollision || AncientHeroSkull.this.hurtTime > 0) {
                    AncientHeroSkull.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class EyeCircleAroundAnchorGoal
    extends EyeMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        EyeCircleAroundAnchorGoal() {
        }

        public boolean canUse() {
            return AncientHeroSkull.this.getTarget() == null || AncientHeroSkull.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void start() {
            this.distance = 5.0f + AncientHeroSkull.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + AncientHeroSkull.this.random.nextFloat() * 9.0f;
            this.clockwise = AncientHeroSkull.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (AncientHeroSkull.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + AncientHeroSkull.this.random.nextFloat() * 9.0f;
            }
            if (AncientHeroSkull.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (AncientHeroSkull.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = AncientHeroSkull.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (AncientHeroSkull.this.moveTargetPoint.y < AncientHeroSkull.this.getY() && !AncientHeroSkull.this.level().isEmptyBlock(AncientHeroSkull.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (AncientHeroSkull.this.moveTargetPoint.y > AncientHeroSkull.this.getY() && !AncientHeroSkull.this.level().isEmptyBlock(AncientHeroSkull.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)AncientHeroSkull.this.anchorPoint)) {
                AncientHeroSkull.this.anchorPoint = AncientHeroSkull.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            AncientHeroSkull.this.moveTargetPoint = Vec3.atLowerCornerOf((Vec3i)AncientHeroSkull.this.anchorPoint).add((double)(this.distance * Mth.cos((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    class EyeAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)20);

        EyeAttackPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)60);
            List list = AncientHeroSkull.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)AncientHeroSkull.this, AncientHeroSkull.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::getY).reversed());
                for (Player player : list) {
                    if (!AncientHeroSkull.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                    AncientHeroSkull.this.setTarget((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = AncientHeroSkull.this.getTarget();
            return livingentity != null ? AncientHeroSkull.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(Mob p_34056_) {
            super(p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            return AncientHeroSkull.this.owner != null && AncientHeroSkull.this.owner.getTarget() != null && this.canAttack(AncientHeroSkull.this.owner.getTarget(), this.copyOwnerTargeting);
        }

        public void start() {
            AncientHeroSkull.this.setTarget(AncientHeroSkull.this.owner.getTarget());
            super.start();
        }
    }

    class EyeBodyRotationControl
    extends BodyRotationControl {
        public EyeBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void clientTick() {
            AncientHeroSkull.this.yHeadRot = AncientHeroSkull.this.yBodyRot;
            AncientHeroSkull.this.yBodyRot = AncientHeroSkull.this.getYRot();
        }
    }

    abstract class EyeMoveTargetGoal
    extends Goal {
        public EyeMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return AncientHeroSkull.this.moveTargetPoint.distanceToSqr(AncientHeroSkull.this.getX(), AncientHeroSkull.this.getY(), AncientHeroSkull.this.getZ()) < 4.0;
        }
    }
}

