/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity.ancienthero;

import github.nitespring.monsterplus.common.entity.ancienthero.AncientHeroSkull;
import github.nitespring.monsterplus.common.entity.projectiles.SkullProjectile;
import github.nitespring.monsterplus.config.CommonConfig;
import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.init.ItemInit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AncientHero
extends AbstractSkeleton {
    private static final EntityDataAccessor<Integer> COMBATSTATE = SynchedEntityData.defineId(AncientHero.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ENTITYSTATE = SynchedEntityData.defineId(AncientHero.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final ResourceLocation SPEED_MODIFIER = ResourceLocation.withDefaultNamespace((String)"ancient_hero_speed_modifier");

    public AncientHero(EntityType<? extends AbstractSkeleton> p_32133_, Level p_32134_) {
        super(p_32133_, p_32134_);
        this.xpReward = 30;
    }

    public boolean canBeAffected(MobEffectInstance pPotioneffect) {
        return pPotioneffect.is(MobEffects.WITHER) ? false : super.canBeAffected(pPotioneffect);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.WITHER_SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_SKELETON_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.WITHER_SKELETON_STEP;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.7).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.ARMOR, 12.0).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.1).add(Attributes.GRAVITY, 0.4).add(Attributes.MOVEMENT_EFFICIENCY, 1.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0);
    }

    public static boolean checkAncientHeroSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && AncientHero.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && AncientHero.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && blockPos.getY() <= 12 && (Boolean)CommonConfig.spawn_ancient_hero.get() != false;
    }

    public void tick() {
        super.tick();
        switch (this.getEntityState()) {
            case 0: {
                if (!(this.getHealth() <= this.getMaxHealth() * 0.75f)) break;
                this.setEntityState(1);
                this.playSound(SoundEvents.ITEM_BREAK);
                this.getAttributes().getInstance(Attributes.ARMOR).setBaseValue(this.getAttributeBaseValue(Attributes.ARMOR) * 0.5);
                this.getAttributes().getInstance(Attributes.ARMOR_TOUGHNESS).setBaseValue(this.getAttributeBaseValue(Attributes.ARMOR_TOUGHNESS) * 0.5);
                this.getAttributes().getInstance(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(this.getAttributeBaseValue(Attributes.KNOCKBACK_RESISTANCE) * 0.5);
                this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED).setBaseValue(this.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) + (double)0.01f);
                this.shootSkull();
                if (this.getTarget() == null || !(this.distanceToSqr((Entity)this.getTarget()) <= 64.0)) break;
                this.setDeltaMovement(this.getTarget().position().add(this.position().scale(-1.0)).scale(-1.0).add(0.0, 0.25, 0.0).normalize().scale(2.5));
                break;
            }
            case 1: {
                if (!(this.getHealth() <= this.getMaxHealth() * 0.5f)) break;
                this.setEntityState(2);
                this.playSound(SoundEvents.WITHER_SPAWN);
                this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED).setBaseValue(this.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) + (double)0.01f);
                this.getAttributes().getInstance(Attributes.ATTACK_SPEED).setBaseValue(this.getAttributeBaseValue(Attributes.ATTACK_SPEED) + 0.25);
                AncientHeroSkull skull = new AncientHeroSkull((EntityType<? extends AncientHeroSkull>)((EntityType)EntityInit.ANCIENT_HERO_SKULL.get()), this.level());
                skull.setPos(this.position().add(0.0, 2.0, 0.0));
                skull.setOwner((Mob)this);
                if (this.getTarget() != null) {
                    skull.setTarget(this.getTarget());
                }
                skull.anchorPoint = BlockPos.containing((Position)this.position().add(0.0, 10.0, 0.0));
                this.level().addFreshEntity((Entity)skull);
                for (int i = 0; i <= 5; ++i) {
                    this.shootSkull();
                }
                if (this.getTarget() == null || !(this.distanceToSqr((Entity)this.getTarget()) <= 64.0)) break;
                this.setDeltaMovement(this.getTarget().position().add(this.position().scale(-1.0)).scale(-1.0).add(0.0, 0.25, 0.0).normalize().scale(2.5));
                break;
            }
            case 2: {
                if (!(this.getHealth() <= this.getMaxHealth() * 0.25f)) break;
                this.setEntityState(3);
                this.playSound(SoundEvents.ITEM_BREAK);
                this.getAttributes().getInstance(Attributes.ARMOR).setBaseValue(0.0);
                this.getAttributes().getInstance(Attributes.ARMOR_TOUGHNESS).setBaseValue(0.0);
                this.getAttributes().getInstance(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
                this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED).setBaseValue(this.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) + (double)0.01f);
                this.shootSkull();
                if (this.getTarget() == null || !(this.distanceToSqr((Entity)this.getTarget()) <= 64.0)) break;
                this.setDeltaMovement(this.getTarget().position().add(this.position().scale(-1.0)).scale(-1.0).add(0.0, 0.25, 0.0).normalize().scale(2.5));
            }
        }
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (pEntity instanceof AncientHeroSkull || pEntity instanceof AncientHero) {
            return true;
        }
        if (pEntity instanceof AncientHeroSkull) {
            AncientHeroSkull skull = (AncientHeroSkull)pEntity;
            if (skull.owner != null && this == skull.owner) {
                return true;
            }
            return skull.isAlliedTo((Entity)this);
        }
        return super.isAlliedTo(pEntity);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AncientHeroAttackGoal(this));
    }

    protected float getEquipmentDropChance(EquipmentSlot pSlot) {
        return 0.0f;
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218949_, DifficultyInstance p_218950_) {
        this.setItemSlot(EquipmentSlot.MAINHAND, ((Item)ItemInit.ANCIENT_BROKEN_SWORD.get()).getDefaultInstance());
    }

    public void aiStep() {
        super.aiStep();
        this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    public void shootSkull() {
        SkullProjectile skull = new SkullProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SPECTRAL_SKULL_PROJECTILE.get()), this.level());
        skull.setOwner((Entity)this);
        if (this.getTarget() != null) {
            skull.setTarget(this.getTarget());
        }
        Vec3 aim = this.getLookAngle();
        Random rn = new Random();
        aim = aim.add((double)(1.5f * (rn.nextFloat() - 0.5f)), (double)(0.75f * rn.nextFloat()), (double)(1.5f * (rn.nextFloat() - 0.5f)));
        skull.setPos(this.position().add(1.5 * aim.x + (double)(2.5f * (rn.nextFloat() - 0.5f)), 1.5 + 0.75 * aim.y, 1.5 * aim.z + (double)(2.5f * (rn.nextFloat() - 0.5f))));
        skull.setDeltaMovement(aim.normalize().scale((double)0.05f));
        skull.accelerationPower = 0.05f;
        skull.setYRot(this.yHeadRot);
        skull.setAttackDamage(4.0f);
        this.level().addFreshEntity((Entity)skull);
    }

    public void performRangedAttack(LivingEntity pTarget, float pDistanceFactor) {
        SkullProjectile skull = new SkullProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.SPECTRAL_SKULL_PROJECTILE.get()), this.level());
        skull.setOwner((Entity)this);
        if (this.getTarget() != null) {
            skull.setTarget(this.getTarget());
        }
        Vec3 aim = this.getLookAngle();
        Random rn = new Random();
        aim = aim.add((double)(0.25f * (rn.nextFloat() - 0.5f)), (double)(0.25f * rn.nextFloat()), (double)(0.25f * (rn.nextFloat() - 0.5f)));
        skull.setPos(this.position().add(1.5 * aim.x, 1.5 + 0.75 * aim.y, 1.5 * aim.z));
        skull.setDeltaMovement(aim.normalize().scale((double)0.05f));
        skull.accelerationPower = 0.075f;
        skull.setYRot(this.yHeadRot);
        skull.setAttackDamage(4.0f);
        this.level().addFreshEntity((Entity)skull);
    }

    public int getEntityState() {
        return (Integer)this.getEntityData().get(ENTITYSTATE);
    }

    public void setEntityState(int i) {
        this.getEntityData().set(ENTITYSTATE, (Object)i);
    }

    public int getCombatState() {
        return (Integer)this.getEntityData().get(COMBATSTATE);
    }

    public void setCombatState(int i) {
        this.getEntityData().set(COMBATSTATE, (Object)i);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENTITYSTATE, (Object)0);
        builder.define(COMBATSTATE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setEntityState(tag.getInt("EntityState"));
        this.setCombatState(tag.getInt("CombatState"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("EntityState", this.getEntityState());
        tag.putInt("CombatState", this.getCombatState());
    }

    public void reassessWeaponGoal() {
    }

    public class AncientHeroAttackGoal
    extends Goal {
        protected final AncientHero mob;
        private final double strafingSpeedModifier = 1.0;
        private final double runningSpeedModifier = 1.2f;
        private boolean followingTargetEvenIfNotSeen = false;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int attackIntervalMin = 16;
        private final float rangedAttackRadiusSqr = 400.0f;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        public int switchCombatStateTick;

        public AncientHeroAttackGoal(AncientHero pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setMinAttackInterval(int pAttackCooldown) {
            this.attackIntervalMin = pAttackCooldown;
        }

        public boolean canUse() {
            long i = this.mob.level().getGameTime();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
            return this.path != null ? true : this.mob.isWithinMeleeAttackRange(livingentity);
        }

        public double getSpeedModifier() {
            return this.mob.getCombatState() == 1 ? 1.0 : (double)1.2f;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.getNavigation().isDone();
            }
            return !this.mob.isWithinRestriction(livingentity.blockPosition()) ? false : !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
        }

        public void start() {
            if (this.mob.getCombatState() != 1) {
                this.mob.getNavigation().moveTo(this.path, this.getSpeedModifier());
            }
            this.mob.setAggressive(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.switchCombatStateTick = 0;
        }

        public void stop() {
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget(null);
            }
            this.mob.setAggressive(false);
            this.mob.getNavigation().stop();
            this.seeTime = 0;
            this.attackTime = -1;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            this.doMovement();
            this.switchCombatStateTick = Math.max(this.switchCombatStateTick - 1, 0);
            if (this.mob.getEntityState() == 2 || this.mob.getEntityState() == 3) {
                if (this.mob.getCombatState() != 0) {
                    AncientHero.this.setCombatState(0);
                }
            } else if (this.switchCombatStateTick <= 0) {
                Random rn = new Random();
                if (AncientHero.this.getCombatState() == 1) {
                    if (rn.nextInt(13) <= 4 || rn.nextInt(13) <= 7 && this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 16.0) {
                        this.mob.setCombatState(0);
                        this.mob.getNavigation().stop();
                        this.ticksUntilNextPathRecalculation = 0;
                    }
                    this.switchCombatStateTick = 160;
                } else {
                    if (rn.nextInt(13) <= 4 || rn.nextInt(13) <= 7 && this.mob.distanceToSqr((Entity)this.mob.getTarget()) >= 36.0) {
                        this.mob.setCombatState(1);
                        this.mob.getNavigation().stop();
                        this.mob.shootSkull();
                        if (this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 64.0) {
                            this.mob.setDeltaMovement(AncientHero.this.getTarget().position().add(AncientHero.this.position().scale(-1.0)).scale(-1.0).add(0.0, 0.25, 0.0).normalize().scale(2.5));
                        }
                    }
                    this.switchCombatStateTick = 240;
                }
            }
            int i = 16;
            switch (this.mob.getCombatState()) {
                case 1: {
                    if (this.mob.tickCount % i != 0) break;
                    AncientHero.this.shootSkull();
                    AncientHero.this.playSound(SoundEvents.WITHER_SHOOT, 0.2f, 0.4f);
                    break;
                }
                default: {
                    i = 48;
                    if (this.mob.getEntityState() == 1) {
                        i = 32;
                    }
                    if (this.mob.getEntityState() == 2) {
                        i = 24;
                    }
                    if (this.mob.getEntityState() == 3) {
                        i = 16;
                    }
                    if (this.mob.tickCount % i != 0) break;
                    AncientHero.this.shootSkull();
                    AncientHero.this.playSound(SoundEvents.WITHER_SHOOT, 0.2f, 0.4f);
                }
            }
        }

        protected void checkAndPerformAttack(LivingEntity pTarget) {
            if (this.canPerformAttack(pTarget)) {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)pTarget);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.adjustedTickDelay(20);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean canPerformAttack(LivingEntity pEntity) {
            return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(pEntity) && this.mob.getSensing().hasLineOfSight((Entity)pEntity);
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.adjustedTickDelay(20);
        }

        public void doMovement() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                boolean flag = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            }
            if (this.mob.getCombatState() == 1) {
                if (livingentity != null) {
                    boolean flag1;
                    double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                    boolean flag = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
                    boolean bl = flag1 = this.seeTime > 0;
                    if (flag != flag1) {
                        this.seeTime = 0;
                    }
                    Objects.requireNonNull(this);
                    if (!(d0 > 400.0) && this.seeTime >= 20) {
                        this.mob.getNavigation().stop();
                        ++this.strafingTime;
                    } else {
                        this.mob.getNavigation().moveTo((Entity)livingentity, this.getSpeedModifier());
                        this.strafingTime = -1;
                    }
                    if (this.strafingTime >= 20) {
                        if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                            boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                        }
                        if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                            this.strafingBackwards = !this.strafingBackwards;
                        }
                        this.strafingTime = 0;
                    }
                    if (this.strafingTime > -1) {
                        if (d0 > (double)(this.rangedAttackRadiusSqr * 0.75f)) {
                            this.strafingBackwards = false;
                        } else if (d0 < (double)(this.rangedAttackRadiusSqr * 0.25f)) {
                            this.strafingBackwards = true;
                        }
                        this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                        Entity entity = this.mob.getControlledVehicle();
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                        }
                        this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                    } else {
                        this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                    }
                    if (--this.attackTime <= 0 && this.seeTime >= -60 && flag) {
                        this.mob.performRangedAttack(livingentity, 0.0f);
                        this.attackTime = this.attackIntervalMin;
                        if (this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 4.0) {
                            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(AncientHero.this.getTarget().position().add(AncientHero.this.position().scale(-1.0)).scale(-1.0).add(0.0, 0.25, 0.0).normalize().scale(0.75)));
                        }
                    }
                }
            } else if (livingentity != null) {
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                    this.pathedTargetX = livingentity.getX();
                    this.pathedTargetY = livingentity.getY();
                    this.pathedTargetZ = livingentity.getZ();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                    double d0 = this.mob.distanceToSqr((Entity)livingentity);
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((finalPathPoint = this.mob.getNavigation().getPath().getEndNode()) != null && livingentity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.getSpeedModifier())) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity);
            }
        }
    }
}

