/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class OvergrownSkeleton
extends AbstractSkeleton {
    public OvergrownSkeleton(EntityType<? extends AbstractSkeleton> p_32133_, Level p_32134_) {
        super(p_32133_, p_32134_);
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.WOOD_STEP;
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219154_, DifficultyInstance p_219155_) {
        int r = this.getRandom().nextInt(4) + 1;
        if (r == 1) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        } else if (r == 2) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        }
    }

    public static boolean checkOvergrownSkeletonSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && OvergrownSkeleton.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && OvergrownSkeleton.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && (Boolean)CommonConfig.spawn_overgrown_skeleton.get() != false;
    }

    protected AbstractArrow getArrow(ItemStack p_33846_, float p_33847_, @Nullable ItemStack p_343583_) {
        AbstractArrow abstractarrow = super.getArrow(p_33846_, p_33847_, p_343583_);
        if (abstractarrow instanceof Arrow) {
            ((Arrow)abstractarrow).addEffect(new MobEffectInstance(MobEffects.POISON, 200));
        }
        return abstractarrow;
    }

    public boolean doHurtTarget(Entity p_34169_) {
        if (!super.doHurtTarget(p_34169_)) {
            return false;
        }
        if (p_34169_ instanceof LivingEntity) {
            ((LivingEntity)p_34169_).addEffect(new MobEffectInstance(MobEffects.POISON, 200), (Entity)this);
        }
        return true;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    public boolean canFreeze() {
        return false;
    }

    protected boolean isSunBurnTick() {
        return false;
    }
}

