/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.config.CommonConfig;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class FlyingSkull
extends FlyingMob
implements Enemy {
    Vec3 moveTargetPoint = Vec3.ZERO;
    BlockPos anchorPoint = BlockPos.ZERO;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    @Nullable
    Mob owner;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public FlyingSkull(EntityType<? extends FlyingSkull> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.xpReward = 5;
        this.moveControl = new EyeMoveControl((Mob)this);
        this.lookControl = new EyeLookControl(this, (Mob)this);
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public static boolean checkFlyingSkullSpawnRules(EntityType<? extends Mob> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && FlyingSkull.isDarkEnoughToSpawn(p_219015_, blockPos, p_219018_) && FlyingSkull.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && blockPos.getY() <= 40 && (Boolean)CommonConfig.spawn_spectral_skull.get() != false;
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.getBrightness(LightLayer.SKY, pPos) > pRandom.nextInt(32)) {
            return false;
        }
        DimensionType dimensiontype = pLevel.dimensionType();
        int i = dimensiontype.monsterSpawnBlockLightLimit();
        if (i < 15 && pLevel.getBrightness(LightLayer.BLOCK, pPos) > i) {
            return false;
        }
        int j = pLevel.getLevel().isThundering() ? pLevel.getMaxLocalRawBrightness(pPos, 10) : pLevel.getMaxLocalRawBrightness(pPos);
        return j <= dimensiontype.monsterSpawnLightTest().sample(pRandom);
    }

    public void setOwner(Mob p_33995_) {
        this.owner = p_33995_;
    }

    public void setLimitedLife(int p_33988_) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = p_33988_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    public void tick() {
        super.tick();
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount % 6 == 0) {
            this.playSound(SoundEvents.CAMPFIRE_CRACKLE, 0.2f, 0.4f);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new EyeAttackStrategyGoal());
        this.goalSelector.addGoal(2, (Goal)new EyeSweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new EyeCircleAroundAnchorGoal());
        this.targetSelector.addGoal(1, (Goal)new EyeAttackPlayerTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new CopyOwnerTargetGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected BodyRotationControl createBodyControl() {
        return new EyeBodyRotationControl((Mob)this);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_33126_, DifficultyInstance p_33127_, MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_) {
        this.anchorPoint = this.blockPosition().above(2);
        return super.finalizeSpawn(p_33126_, p_33127_, p_33128_, p_33129_);
    }

    public void readAdditionalSaveData(CompoundTag p_33132_) {
        super.readAdditionalSaveData(p_33132_);
        if (p_33132_.contains("AX")) {
            this.anchorPoint = new BlockPos(p_33132_.getInt("AX"), p_33132_.getInt("AY"), p_33132_.getInt("AZ"));
        }
    }

    public void addAdditionalSaveData(CompoundTag p_33141_) {
        super.addAdditionalSaveData(p_33141_);
        p_33141_.putInt("AX", this.anchorPoint.getX());
        p_33141_.putInt("AY", this.anchorPoint.getY());
        p_33141_.putInt("AZ", this.anchorPoint.getZ());
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean canAttackType(EntityType<?> p_33111_) {
        return true;
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (this.getOwner() != null) {
            if (pEntity == this.owner) {
                return true;
            }
            return this.getOwner().isAlliedTo(pEntity);
        }
        return super.isAlliedTo(pEntity);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class EyeMoveControl
    extends MoveControl {
        private float speed;

        public EyeMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void tick() {
            if (FlyingSkull.this.horizontalCollision) {
                FlyingSkull.this.setYRot(FlyingSkull.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = FlyingSkull.this.moveTargetPoint.x - FlyingSkull.this.getX();
            double d1 = FlyingSkull.this.moveTargetPoint.y - FlyingSkull.this.getY();
            double d2 = FlyingSkull.this.moveTargetPoint.z - FlyingSkull.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = FlyingSkull.this.getYRot();
                float f1 = (float)Mth.atan2((double)d2, (double)d0);
                float f2 = Mth.wrapDegrees((float)(FlyingSkull.this.getYRot() + 90.0f));
                float f3 = Mth.wrapDegrees((float)(f1 * 57.295776f));
                FlyingSkull.this.setYRot(Mth.approachDegrees((float)f2, (float)f3, (float)4.0f) - 90.0f);
                FlyingSkull.this.yBodyRot = FlyingSkull.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs((float)f, (float)FlyingSkull.this.getYRot()) < 3.0f ? Mth.approach((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.approach((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.atan2((double)(-d1), (double)d3) * 57.2957763671875));
                FlyingSkull.this.setXRot(f4);
                float f5 = FlyingSkull.this.getYRot() + 90.0f;
                double d6 = (double)(this.speed * Mth.cos((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.sin((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.sin((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = FlyingSkull.this.getDeltaMovement();
                FlyingSkull.this.setDeltaMovement(vec3.add(new Vec3(d6, d8, d7).subtract(vec3).scale(0.2)));
            }
        }
    }

    class EyeLookControl
    extends LookControl {
        public EyeLookControl(FlyingSkull this$0, Mob p_33235_) {
            super(p_33235_);
        }

        public void tick() {
        }
    }

    class EyeAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        EyeAttackStrategyGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = FlyingSkull.this.getTarget();
            return livingentity != null ? FlyingSkull.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }

        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            FlyingSkull.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            FlyingSkull.this.anchorPoint = FlyingSkull.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, FlyingSkull.this.anchorPoint).above(1 + FlyingSkull.this.random.nextInt(5));
        }

        public void tick() {
            if (FlyingSkull.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    FlyingSkull.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + FlyingSkull.this.random.nextInt(4)) * 20);
                }
            }
        }

        private void setAnchorAboveTarget() {
            FlyingSkull.this.anchorPoint = FlyingSkull.this.getTarget().blockPosition().above(FlyingSkull.this.random.nextInt(5));
        }
    }

    class EyeSweepAttackGoal
    extends EyeMoveTargetGoal {
        private boolean isScaredOfCat;
        private int catSearchTick;

        EyeSweepAttackGoal() {
        }

        public boolean canUse() {
            return FlyingSkull.this.getTarget() != null && FlyingSkull.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = FlyingSkull.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.isSpectator() || player.isCreative()) {
                    return false;
                }
            }
            if (!this.canUse()) {
                return false;
            }
            if (FlyingSkull.this.tickCount > this.catSearchTick) {
                this.catSearchTick = FlyingSkull.this.tickCount + 20;
                List list = FlyingSkull.this.level().getEntitiesOfClass(Cat.class, FlyingSkull.this.getBoundingBox().inflate(16.0), EntitySelector.ENTITY_STILL_ALIVE);
                for (Cat cat : list) {
                    cat.hiss();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void start() {
        }

        public void stop() {
            FlyingSkull.this.setTarget(null);
            FlyingSkull.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void tick() {
            LivingEntity livingentity = FlyingSkull.this.getTarget();
            if (livingentity != null) {
                FlyingSkull.this.moveTargetPoint = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
                if (FlyingSkull.this.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
                    FlyingSkull.this.doHurtTarget((Entity)livingentity);
                    FlyingSkull.this.attackPhase = AttackPhase.CIRCLE;
                    if (!FlyingSkull.this.isSilent()) {
                        FlyingSkull.this.level().levelEvent(1039, FlyingSkull.this.blockPosition(), 0);
                    }
                } else if (FlyingSkull.this.horizontalCollision || FlyingSkull.this.hurtTime > 0) {
                    FlyingSkull.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class EyeCircleAroundAnchorGoal
    extends EyeMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        EyeCircleAroundAnchorGoal() {
        }

        public boolean canUse() {
            return FlyingSkull.this.getTarget() == null || FlyingSkull.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void start() {
            this.distance = 5.0f + FlyingSkull.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + FlyingSkull.this.random.nextFloat() * 9.0f;
            this.clockwise = FlyingSkull.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (FlyingSkull.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + FlyingSkull.this.random.nextFloat() * 9.0f;
            }
            if (FlyingSkull.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (FlyingSkull.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = FlyingSkull.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (FlyingSkull.this.moveTargetPoint.y < FlyingSkull.this.getY() && !FlyingSkull.this.level().isEmptyBlock(FlyingSkull.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (FlyingSkull.this.moveTargetPoint.y > FlyingSkull.this.getY() && !FlyingSkull.this.level().isEmptyBlock(FlyingSkull.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)FlyingSkull.this.anchorPoint)) {
                FlyingSkull.this.anchorPoint = FlyingSkull.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            FlyingSkull.this.moveTargetPoint = Vec3.atLowerCornerOf((Vec3i)FlyingSkull.this.anchorPoint).add((double)(this.distance * Mth.cos((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    class EyeAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)20);

        EyeAttackPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)60);
            List list = FlyingSkull.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)FlyingSkull.this, FlyingSkull.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::getY).reversed());
                for (Player player : list) {
                    if (!FlyingSkull.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                    FlyingSkull.this.setTarget((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = FlyingSkull.this.getTarget();
            return livingentity != null ? FlyingSkull.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(Mob p_34056_) {
            super(p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            return FlyingSkull.this.owner != null && FlyingSkull.this.owner.getTarget() != null && this.canAttack(FlyingSkull.this.owner.getTarget(), this.copyOwnerTargeting);
        }

        public void start() {
            FlyingSkull.this.setTarget(FlyingSkull.this.owner.getTarget());
            super.start();
        }
    }

    class EyeBodyRotationControl
    extends BodyRotationControl {
        public EyeBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void clientTick() {
            FlyingSkull.this.yHeadRot = FlyingSkull.this.yBodyRot;
            FlyingSkull.this.yBodyRot = FlyingSkull.this.getYRot();
        }
    }

    abstract class EyeMoveTargetGoal
    extends Goal {
        public EyeMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return FlyingSkull.this.moveTargetPoint.distanceToSqr(FlyingSkull.this.getX(), FlyingSkull.this.getY(), FlyingSkull.this.getZ()) < 4.0;
        }
    }
}

