/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.CustomSpellcaster;
import github.nitespring.monsterplus.common.entity.DesertAcolyte;
import github.nitespring.monsterplus.common.entity.Eye;
import github.nitespring.monsterplus.common.entity.SpectralSkeleton;
import github.nitespring.monsterplus.common.entity.projectiles.Flame;
import github.nitespring.monsterplus.common.entity.projectiles.SorceressFireSpawner;
import github.nitespring.monsterplus.config.CommonConfig;
import github.nitespring.monsterplus.core.init.EntityInit;
import github.nitespring.monsterplus.core.init.SoundInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DesertSorceress
extends CustomSpellcaster {
    public DesertSorceress(EntityType<? extends SpellcasterIllager> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
        this.xpReward = 15;
    }

    public boolean canJoinRaid() {
        return super.canJoinRaid();
    }

    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)SoundInit.DESERT_SORCERESS_CAST.get();
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)SoundInit.DESERT_SORCERESS_CELEBRATE.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, 8.0f, 0.6, 1.0, p_28879_ -> p_28879_ == this.getTarget()));
        this.goalSelector.addGoal(5, (Goal)new FlameSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new FireballSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new FlameWallSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new FireballBarrageSpellGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int i, boolean b) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.MAX_HEALTH, 36.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isAlliedTo(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.isAlliedTo(p_32665_)) {
            return true;
        }
        if (p_32665_ instanceof Eye) {
            return this.isAlliedTo((Entity)((Eye)p_32665_).getOwner());
        }
        if (p_32665_ instanceof SpectralSkeleton) {
            return this.isAlliedTo((Entity)((SpectralSkeleton)p_32665_).getOwner());
        }
        if (p_32665_ instanceof DesertSorceress || p_32665_ instanceof DesertAcolyte) {
            return this.getTeam() == null && p_32665_.getTeam() == null;
        }
        if (p_32665_ instanceof LivingEntity && ((LivingEntity)p_32665_).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && p_32665_.getTeam() == null;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundInit.DESERT_SORCERESS_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundInit.DESERT_SORCERESS_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_32654_) {
        return (SoundEvent)SoundInit.DESERT_SORCERESS_HURT.get();
    }

    public static boolean checkDesertSorceressSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && DesertSorceress.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && DesertSorceress.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && (Boolean)CommonConfig.spawn_desert_sorceress.get() != false;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
            super((SpellcasterIllager)DesertSorceress.this);
        }

        public void tick() {
            if (DesertSorceress.this.getTarget() != null) {
                DesertSorceress.this.getLookControl().setLookAt((Entity)DesertSorceress.this.getTarget(), (float)DesertSorceress.this.getMaxHeadYRot(), (float)DesertSorceress.this.getMaxHeadXRot());
            }
        }
    }

    class FlameSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FlameSpellGoal() {
            super((SpellcasterIllager)DesertSorceress.this);
        }

        protected int getCastingTime() {
            return 35;
        }

        protected int getTotalCastingTime() {
            return this.getCastWarmupTime() + this.getCastingTime();
        }

        protected int getCastingInterval() {
            return 160;
        }

        protected int getCastWarmupTime() {
            return 20;
        }

        public boolean canUse() {
            LivingEntity livingentity = DesertSorceress.this.getTarget();
            if (livingentity == null || !livingentity.isAlive() || livingentity.distanceTo((Entity)DesertSorceress.this) >= 10.0f) {
                return false;
            }
            return DesertSorceress.this.isCastingSpell() ? false : DesertSorceress.this.tickCount >= this.nextAttackTickCount;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = DesertSorceress.this.getTarget();
            return livingentity != null && livingentity.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getTotalCastingTime());
            DesertSorceress.this.spellCastingTickCount = this.getTotalCastingTime() - 2;
            this.nextAttackTickCount = DesertSorceress.this.tickCount + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                DesertSorceress.this.playSound(soundevent, 1.0f, 1.0f);
            }
            DesertSorceress.this.setIsCastingSpell(this.getSpell());
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == this.getCastingTime()) {
                this.performSpellCasting();
                DesertSorceress.this.playSound(DesertSorceress.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
            if (this.attackWarmupDelay <= this.getCastingTime() && this.attackWarmupDelay % 3 == 0) {
                this.performSpellCasting();
            }
        }

        protected void performSpellCasting() {
            Vec3 pos = DesertSorceress.this.position();
            Vec3 posO = new Vec3(pos.x, pos.y + 2.5, pos.z);
            Vec3 pos1 = DesertSorceress.this.getTarget().position();
            Vec3 posT = new Vec3(pos1.x, DesertSorceress.this.getTarget().getY(0.5) + 0.5, pos1.z);
            double d0 = Math.sqrt((posT.x - posO.x) * (posT.x - posO.x) + (posT.y - posO.y) * (posT.y - posO.y) + (posT.z - posO.z) * (posT.z - posO.z));
            for (int i = 0; i < 3; ++i) {
                Vec3 aim = new Vec3((posT.x - posO.x) / d0, (posT.y - posO.y) / d0, (posT.z - posO.z) / d0);
                this.throwFlame(posO, aim.add((double)this.randomFloat(0.1f), (double)this.randomFloat(0.1f), (double)this.randomFloat(0.1f)), 2.0f);
            }
        }

        float randomFloat(float peak) {
            Random r = new Random();
            float f = r.nextFloat(-1.0f, 1.0f) * peak;
            return f;
        }

        private void throwFlame(Vec3 pos, Vec3 aim, float damage) {
            Flame fireball = new Flame((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.FLAME.get()), DesertSorceress.this.level());
            fireball.setPos(pos.x, pos.y, pos.z);
            fireball.setDeltaMovement(aim.x * (double)0.1f, aim.y * (double)0.1f + (double)0.0015f, aim.z * (double)0.1f);
            fireball.setAttackDamage(damage);
            fireball.setFlyingTime(18);
            fireball.setOwner((Entity)DesertSorceress.this);
            DesertSorceress.this.level().addFreshEntity((Entity)fireball);
            DesertSorceress.this.playSound(SoundEvents.FIRE_AMBIENT, 0.5f, 0.75f);
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.FIRECHARGE_USE;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    class FireballSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FireballSpellGoal() {
            super((SpellcasterIllager)DesertSorceress.this);
        }

        protected int getCastingTime() {
            return 50;
        }

        protected int getCastingInterval() {
            return 200;
        }

        protected void performSpellCasting() {
            Vec3 pos = DesertSorceress.this.position();
            Vec3 posO = new Vec3(pos.x, pos.y + 2.5, pos.z);
            Vec3 pos1 = DesertSorceress.this.getTarget().position();
            Vec3 posT = new Vec3(pos1.x, DesertSorceress.this.getTarget().getY(0.5), pos1.z);
            double d0 = Math.sqrt((posT.x - posO.x) * (posT.x - posO.x) + (posT.y - posO.y) * (posT.y - posO.y) + (posT.z - posO.z) * (posT.z - posO.z));
            Vec3 aim = new Vec3((posT.x - posO.x) / d0, (posT.y - posO.y) / d0, (posT.z - posO.z) / d0);
            this.launchFireball(posO, aim, 4.0f);
        }

        private void launchFireball(Vec3 pos, Vec3 aim, float damage) {
            LargeFireball fireball = new LargeFireball(EntityType.FIREBALL, DesertSorceress.this.level());
            fireball.setPos(pos.x, pos.y, pos.z);
            fireball.setDeltaMovement(aim.x * 0.5, aim.y * 0.5, aim.z * 0.5);
            fireball.setOwner((Entity)DesertSorceress.this);
            DesertSorceress.this.level().addFreshEntity((Entity)fireball);
            DesertSorceress.this.playSound(SoundEvents.FIRE_AMBIENT, 0.5f, 0.75f);
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.FIRECHARGE_USE;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    class FlameWallSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FlameWallSpellGoal() {
            super((SpellcasterIllager)DesertSorceress.this);
        }

        public boolean canUse() {
            if (!DesertSorceress.this.isAlive()) {
                return false;
            }
            return super.canUse();
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 80;
        }

        protected void performSpellCasting() {
            LivingEntity livingentity = DesertSorceress.this.getTarget();
            double d0 = Math.min(livingentity.getY(), DesertSorceress.this.getY());
            double d1 = Math.max(livingentity.getY(), DesertSorceress.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingentity.getZ() - DesertSorceress.this.getZ()), (double)(livingentity.getX() - DesertSorceress.this.getX()));
            if (DesertSorceress.this.distanceToSqr((Entity)livingentity) < 32.0 || DesertSorceress.this.distanceToSqr((Entity)livingentity) < 64.0 && DesertSorceress.this.getRandom().nextBoolean()) {
                float f1;
                int i;
                for (i = 0; i < 8; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 1.0f / 4.0f;
                    this.createSpellEntity(DesertSorceress.this.getX() + (double)Mth.cos((float)f1) * 2.5, DesertSorceress.this.getZ() + (double)Mth.sin((float)f1) * 2.5, d0, d1, f1, 1);
                }
                for (i = 0; i < 32; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 1.0f / 16.0f;
                    this.createSpellEntity(DesertSorceress.this.getX() + (double)Mth.cos((float)f1) * 6.5, DesertSorceress.this.getZ() + (double)Mth.sin((float)f1) * 6.5, d0, d1, f1, 1);
                }
            } else {
                int randomPattern = new Random().nextInt(2) + 1;
                switch (randomPattern) {
                    case 1: {
                        for (int l = 0; l < 16; ++l) {
                            double d2 = 1.25 * (double)(l + 1);
                            int j = 1 * l;
                            this.createSpellEntity(DesertSorceress.this.getX() + (double)Mth.cos((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), DesertSorceress.this.getZ() + (double)Mth.sin((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), d0, d1, f, j);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < 16; ++i) {
                            float f1 = f + (float)i * (float)Math.PI * 1.0f / 8.0f;
                            this.createSpellEntity(DesertSorceress.this.getTarget().getX() + (double)Mth.cos((float)f1) * 4.5, DesertSorceress.this.getTarget().getZ() + (double)Mth.sin((float)f1) * 4.5, d0, d1, f1, 1);
                        }
                        break;
                    }
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = new BlockPos(new Vec3i((int)p_32673_, (int)p_32676_, (int)p_32674_));
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = DesertSorceress.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)DesertSorceress.this.level(), blockpos1, Direction.UP)) continue;
                if (!DesertSorceress.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = DesertSorceress.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)DesertSorceress.this.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
            if (flag) {
                DesertSorceress.this.level().addFreshEntity((Entity)new SorceressFireSpawner(DesertSorceress.this.level(), 4.0f, p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)DesertSorceress.this));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.FIRECHARGE_USE;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    class FireballBarrageSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FireballBarrageSpellGoal() {
            super((SpellcasterIllager)DesertSorceress.this);
        }

        protected int getCastingTime() {
            return 20;
        }

        protected int getTotalCastingTime() {
            return this.getCastWarmupTime() + this.getCastingTime();
        }

        protected int getCastingInterval() {
            return 180;
        }

        protected int getCastWarmupTime() {
            return 25;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = DesertSorceress.this.getTarget();
            return livingentity != null && livingentity.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getTotalCastingTime());
            DesertSorceress.this.spellCastingTickCount = this.getTotalCastingTime() - 2;
            this.nextAttackTickCount = DesertSorceress.this.tickCount + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                DesertSorceress.this.playSound(soundevent, 1.0f, 1.0f);
            }
            DesertSorceress.this.setIsCastingSpell(this.getSpell());
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == this.getCastingTime()) {
                this.performSpellCasting();
                DesertSorceress.this.playSound(DesertSorceress.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
            if (this.attackWarmupDelay <= this.getCastingTime() && this.attackWarmupDelay % 3 == 0) {
                this.performSpellCasting();
            }
        }

        protected void performSpellCasting() {
            Vec3 pos = DesertSorceress.this.position();
            Vec3 posO = new Vec3(pos.x, pos.y + 3.5, pos.z);
            Vec3 pos1 = DesertSorceress.this.getTarget().position();
            Vec3 posT = new Vec3(pos1.x, DesertSorceress.this.getTarget().getY(0.5) + 0.5, pos1.z);
            double d0 = Math.sqrt((posT.x - posO.x) * (posT.x - posO.x) + (posT.y - posO.y) * (posT.y - posO.y) + (posT.z - posO.z) * (posT.z - posO.z));
            Vec3 aim = new Vec3((posT.x - posO.x) / d0, (posT.y - posO.y) / d0, (posT.z - posO.z) / d0);
            this.throwFireball(posO.add((double)this.randomFloat(1.5f), (double)this.randomFloat(1.5f), (double)this.randomFloat(1.5f)), aim.add((double)this.randomFloat(0.15f), (double)this.randomFloat(0.15f), (double)this.randomFloat(0.15f)), 2.0f);
        }

        float randomFloat(float peak) {
            Random r = new Random();
            float f = r.nextFloat(-1.0f, 1.0f) * peak;
            return f;
        }

        private void throwFireball(Vec3 pos, Vec3 aim, float damage) {
            SmallFireball fireball = new SmallFireball(EntityType.SMALL_FIREBALL, DesertSorceress.this.level());
            fireball.setPos(pos.x, pos.y, pos.z);
            fireball.setDeltaMovement(aim.x * (double)0.1f, aim.y * (double)0.1f, aim.z * (double)0.1f);
            fireball.setOwner((Entity)DesertSorceress.this);
            DesertSorceress.this.level().addFreshEntity((Entity)fireball);
            DesertSorceress.this.playSound(SoundEvents.FIRE_AMBIENT, 0.5f, 0.75f);
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.FIRECHARGE_USE;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

