/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.config.CommonConfig;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class DemonEye
extends FlyingMob
implements Enemy {
    Vec3 moveTargetPoint = Vec3.ZERO;
    BlockPos anchorPoint = BlockPos.ZERO;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    @Nullable
    Mob owner;
    private static final EntityDataAccessor<Integer> EYE_TYPE = SynchedEntityData.defineId(DemonEye.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIMATIONSTATE = SynchedEntityData.defineId(DemonEye.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> EYE_SCALE = SynchedEntityData.defineId(DemonEye.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(DemonEye.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    int animationTick;
    public static final ResourceLocation ATTACK_DAMAGE_MODIFIER_TEETH = ResourceLocation.withDefaultNamespace((String)"fanged_demon_eye_attack_damage_modifier");
    public static final ResourceLocation HEALTH_MODIFIER_SIZE = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"large_demon_eye_max_health_modifier");
    public static final ResourceLocation SPEED_MODIFIER_SIZE = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"small_demon_eye_movement_speed_modifier");

    public DemonEye(EntityType<? extends DemonEye> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.xpReward = 7;
        this.moveControl = new EyeMoveControl((Mob)this);
        this.lookControl = new EyeLookControl(this, (Mob)this);
    }

    public int getEyeType() {
        return (Integer)this.getEntityData().get(EYE_TYPE);
    }

    public void setEyeType(int i) {
        this.getEntityData().set(EYE_TYPE, (Object)i);
    }

    public int getAnimationState() {
        return (Integer)this.getEntityData().get(ANIMATIONSTATE);
    }

    public void setAnimationState(int i) {
        this.getEntityData().set(ANIMATIONSTATE, (Object)i);
    }

    public float getEyeScale() {
        return ((Float)this.getEntityData().get(EYE_SCALE)).floatValue();
    }

    public void setEyeScale(float f) {
        this.getEntityData().set(EYE_SCALE, (Object)Float.valueOf(f));
    }

    public float getDimensionScale() {
        return ((Float)this.getEntityData().get(SCALE)).floatValue();
    }

    public void setDimensionScale(float f) {
        this.getEntityData().set(SCALE, (Object)Float.valueOf(f));
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob p_33995_) {
        this.owner = p_33995_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_SPEED, 1.2).add(Attributes.ATTACK_KNOCKBACK, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EYE_TYPE, (Object)0);
        builder.define(ANIMATIONSTATE, (Object)0);
        builder.define(EYE_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("AX")) {
            this.anchorPoint = new BlockPos(tag.getInt("AX"), tag.getInt("AY"), tag.getInt("AZ"));
        }
        this.setEyeType(tag.getInt("EyeType"));
        this.setEyeScale(tag.getFloat("EyeScale"));
        this.setDimensionScale(tag.getFloat("Scale"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("AX", this.anchorPoint.getX());
        tag.putInt("AY", this.anchorPoint.getY());
        tag.putInt("AZ", this.anchorPoint.getZ());
        tag.putInt("EyeType", this.getEyeType());
        tag.putFloat("EyeScale", this.getEyeScale());
        tag.putFloat("Scale", this.getDimensionScale());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_33126_, DifficultyInstance p_33127_, MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_) {
        this.anchorPoint = this.blockPosition().above(10);
        this.randomizeEyeColour();
        this.randomizeEyeBallSize();
        this.randomizeSize();
        return super.finalizeSpawn(p_33126_, p_33127_, p_33128_, p_33129_);
    }

    public void randomizeEyeColour() {
        Random rn = new Random();
        int r = rn.nextInt(24) + 1;
        switch (r) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.setEyeType(1);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.setEyeType(2);
                break;
            }
            case 11: 
            case 12: {
                this.setEyeType(3);
                break;
            }
            case 13: {
                this.setEyeType(4);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.setEyeType(5);
                this.getAttributes().getInstance(Attributes.ATTACK_DAMAGE).addPermanentModifier(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_TEETH, 2.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            default: {
                this.setEyeType(0);
            }
        }
    }

    public void randomizeEyeBallSize() {
        Random rn = new Random();
        this.setEyeScale(0.9f + 0.35f * rn.nextFloat());
    }

    public void randomizeSize() {
        Random rn = new Random();
        int r = rn.nextInt(13);
        switch (r) {
            case 1: 
            case 2: {
                this.setDimensionScale(0.5f + 0.25f * rn.nextFloat());
                this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(SPEED_MODIFIER_SIZE, (double)0.02f, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setDimensionScale(1.0f + 0.25f * (2.0f * rn.nextFloat() - 1.0f));
                break;
            }
            case 8: 
            case 9: {
                this.setDimensionScale(1.25f + 0.25f * rn.nextFloat());
                this.getAttributes().getInstance(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(HEALTH_MODIFIER_SIZE, 4.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 10: {
                this.setDimensionScale(1.5f + 0.5f * rn.nextFloat());
                this.getAttributes().getInstance(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(HEALTH_MODIFIER_SIZE, 8.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            default: {
                this.setDimensionScale(1.0f);
            }
        }
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    public void aiStep() {
        boolean flag;
        super.aiStep();
        ++this.animationTick;
        boolean bl = flag = this.isSunSensitive() && this.isSunBurnTick();
        if (flag) {
            this.igniteForSeconds(8.0f);
        }
        if (this.getEyeType() == 5) {
            if (this.getAnimationState() == 1) {
                if (this.animationTick >= 4) {
                    this.setAnimationState(0);
                    this.animationTick = 0;
                }
            } else if (this.animationTick >= 8) {
                this.setAnimationState(1);
                this.animationTick = 0;
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new EyeAttackStrategyGoal());
        this.goalSelector.addGoal(2, (Goal)new EyeSweepAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new EyeCircleAroundAnchorGoal());
        this.targetSelector.addGoal(2, (Goal)new CopyOwnerTargetGoal((Mob)this));
        this.registerTargets();
    }

    public void registerTargets() {
        this.targetSelector.addGoal(1, (Goal)new EyeAttackPlayerTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal(this, this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected BodyRotationControl createBodyControl() {
        return new EyeBodyRotationControl((Mob)this);
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public static boolean checkDemonEyeSpawnRules(EntityType<? extends DemonEye> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getDifficulty() != Difficulty.PEACEFUL && (Boolean)CommonConfig.spawn_demon_eye.get() != false && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && pLevel.canSeeSky(pPos) && DemonEye.checkMobSpawnRules(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    protected boolean isSunSensitive() {
        return true;
    }

    public boolean canAttackType(EntityType<?> p_33111_) {
        return true;
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class EyeMoveControl
    extends MoveControl {
        private float speed;

        public EyeMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void tick() {
            if (DemonEye.this.horizontalCollision) {
                DemonEye.this.setYRot(DemonEye.this.getYRot() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = DemonEye.this.moveTargetPoint.x - DemonEye.this.getX();
            double d1 = DemonEye.this.moveTargetPoint.y - DemonEye.this.getY();
            double d2 = DemonEye.this.moveTargetPoint.z - DemonEye.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = DemonEye.this.getYRot();
                float f1 = (float)Mth.atan2((double)d2, (double)d0);
                float f2 = Mth.wrapDegrees((float)(DemonEye.this.getYRot() + 90.0f));
                float f3 = Mth.wrapDegrees((float)(f1 * 57.295776f));
                DemonEye.this.setYRot(Mth.approachDegrees((float)f2, (float)f3, (float)4.0f) - 90.0f);
                DemonEye.this.yBodyRot = DemonEye.this.getYRot();
                this.speed = Mth.degreesDifferenceAbs((float)f, (float)DemonEye.this.getYRot()) < 3.0f ? Mth.approach((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.approach((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.atan2((double)(-d1), (double)d3) * 57.2957763671875));
                DemonEye.this.setXRot(f4);
                float f5 = DemonEye.this.getYRot() + 90.0f;
                double d6 = (double)(this.speed * Mth.cos((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.sin((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.sin((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = DemonEye.this.getDeltaMovement();
                DemonEye.this.setDeltaMovement(vec3.add(new Vec3(d6, d8, d7).subtract(vec3).scale(0.2)));
            }
        }
    }

    class EyeLookControl
    extends LookControl {
        public EyeLookControl(DemonEye this$0, Mob p_33235_) {
            super(p_33235_);
        }

        public void tick() {
        }
    }

    class EyeAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        EyeAttackStrategyGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = DemonEye.this.getTarget();
            return livingentity != null ? DemonEye.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }

        public void start() {
            this.nextSweepTick = this.adjustedTickDelay(10);
            DemonEye.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void stop() {
            DemonEye.this.anchorPoint = DemonEye.this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, DemonEye.this.anchorPoint).above(10 + DemonEye.this.random.nextInt(20));
        }

        public void tick() {
            if (DemonEye.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    DemonEye.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.adjustedTickDelay((8 + DemonEye.this.random.nextInt(4)) * 20);
                }
            }
        }

        private void setAnchorAboveTarget() {
            DemonEye.this.anchorPoint = DemonEye.this.getTarget().blockPosition().above(20 + DemonEye.this.random.nextInt(20));
        }
    }

    class EyeSweepAttackGoal
    extends EyeMoveTargetGoal {
        private boolean isScaredOfCat;
        private int catSearchTick;

        EyeSweepAttackGoal() {
        }

        public boolean canUse() {
            return DemonEye.this.getTarget() != null && DemonEye.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = DemonEye.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.isSpectator() || player.isCreative()) {
                    return false;
                }
            }
            if (!this.canUse()) {
                return false;
            }
            if (DemonEye.this.tickCount > this.catSearchTick) {
                this.catSearchTick = DemonEye.this.tickCount + 20;
                List list = DemonEye.this.level().getEntitiesOfClass(Cat.class, DemonEye.this.getBoundingBox().inflate(16.0), EntitySelector.ENTITY_STILL_ALIVE);
                for (Cat cat : list) {
                    cat.hiss();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void start() {
        }

        public void stop() {
            DemonEye.this.setTarget(null);
            DemonEye.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void tick() {
            LivingEntity livingentity = DemonEye.this.getTarget();
            if (livingentity != null) {
                DemonEye.this.moveTargetPoint = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
                if (DemonEye.this.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
                    DemonEye.this.doHurtTarget((Entity)livingentity);
                    DemonEye.this.attackPhase = AttackPhase.CIRCLE;
                    if (!DemonEye.this.isSilent()) {
                        DemonEye.this.level().levelEvent(1039, DemonEye.this.blockPosition(), 0);
                    }
                } else if (DemonEye.this.horizontalCollision || DemonEye.this.hurtTime > 0) {
                    DemonEye.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class EyeCircleAroundAnchorGoal
    extends EyeMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        EyeCircleAroundAnchorGoal() {
        }

        public boolean canUse() {
            return DemonEye.this.getTarget() == null || DemonEye.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void start() {
            this.distance = 5.0f + DemonEye.this.random.nextFloat() * 10.0f;
            this.height = -4.0f + DemonEye.this.random.nextFloat() * 9.0f;
            this.clockwise = DemonEye.this.random.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void tick() {
            if (DemonEye.this.random.nextInt(this.adjustedTickDelay(350)) == 0) {
                this.height = -4.0f + DemonEye.this.random.nextFloat() * 9.0f;
            }
            if (DemonEye.this.random.nextInt(this.adjustedTickDelay(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (DemonEye.this.random.nextInt(this.adjustedTickDelay(450)) == 0) {
                this.angle = DemonEye.this.random.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (DemonEye.this.moveTargetPoint.y < DemonEye.this.getY() && !DemonEye.this.level().isEmptyBlock(DemonEye.this.blockPosition().below(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (DemonEye.this.moveTargetPoint.y > DemonEye.this.getY() && !DemonEye.this.level().isEmptyBlock(DemonEye.this.blockPosition().above(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.ZERO.equals((Object)DemonEye.this.anchorPoint)) {
                DemonEye.this.anchorPoint = DemonEye.this.blockPosition();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            DemonEye.this.moveTargetPoint = Vec3.atLowerCornerOf((Vec3i)DemonEye.this.anchorPoint).add((double)(this.distance * Mth.cos((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.sin((float)this.angle)));
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(Mob p_34056_) {
            super(p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            return DemonEye.this.owner != null && DemonEye.this.owner.getTarget() != null && this.canAttack(DemonEye.this.owner.getTarget(), this.copyOwnerTargeting);
        }

        public void start() {
            DemonEye.this.setTarget(DemonEye.this.owner.getTarget());
            super.start();
        }
    }

    class EyeAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)20);

        EyeAttackPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = EyeAttackPlayerTargetGoal.reducedTickDelay((int)60);
            List list = DemonEye.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)DemonEye.this, DemonEye.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::getY).reversed());
                for (Player player : list) {
                    if (!DemonEye.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                    DemonEye.this.setTarget((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = DemonEye.this.getTarget();
            return livingentity != null ? DemonEye.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }
    }

    public class HurtByTargetGoal
    extends TargetGoal {
        private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public HurtByTargetGoal(DemonEye this$0, DemonEye pMob, Class<?> ... pToIgnoreDamage) {
            super((Mob)pMob, true);
            this.toIgnoreDamage = pToIgnoreDamage;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            int i = this.mob.getLastHurtByMobTimestamp();
            LivingEntity livingentity = this.mob.getLastHurtByMob();
            if (i != this.timestamp && livingentity != null) {
                if (livingentity.getType() == EntityType.PLAYER && this.mob.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                    return false;
                }
                for (Class<?> oclass : this.toIgnoreDamage) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return false;
                }
                return this.canAttack(livingentity, HURT_BY_TARGETING);
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.mob.getLastHurtByMob());
            this.targetMob = this.mob.getTarget();
            this.timestamp = this.mob.getLastHurtByMobTimestamp();
            this.unseenMemoryTicks = 300;
            super.start();
        }
    }

    class EyeBodyRotationControl
    extends BodyRotationControl {
        public EyeBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void clientTick() {
            DemonEye.this.yHeadRot = DemonEye.this.yBodyRot;
            DemonEye.this.yBodyRot = DemonEye.this.getYRot();
        }
    }

    abstract class EyeMoveTargetGoal
    extends Goal {
        public EyeMoveTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return DemonEye.this.moveTargetPoint.distanceToSqr(DemonEye.this.getX(), DemonEye.this.getY(), DemonEye.this.getZ()) < 4.0;
        }
    }

    class EyeAttackLastHurtByPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
        private int nextScanTick = EyeAttackLastHurtByPlayerTargetGoal.reducedTickDelay((int)20);

        EyeAttackLastHurtByPlayerTargetGoal() {
        }

        public boolean canUse() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = EyeAttackLastHurtByPlayerTargetGoal.reducedTickDelay((int)60);
            List list = DemonEye.this.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)DemonEye.this, DemonEye.this.getBoundingBox().inflate(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::getY).reversed());
                for (Player player : list) {
                    if (DemonEye.this.getLastAttacker() != player || !DemonEye.this.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                    DemonEye.this.setTarget((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = DemonEye.this.getTarget();
            return livingentity != null ? DemonEye.this.canAttack(livingentity, TargetingConditions.DEFAULT) : false;
        }
    }
}

