/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.common.entity;

import github.nitespring.monsterplus.common.entity.projectiles.SpikeCountdown;
import github.nitespring.monsterplus.config.CommonConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalZombie
extends Zombie {
    public CrystalZombie(EntityType<? extends Zombie> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
    }

    public static boolean checkCrystalZombieSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && CrystalZombie.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && CrystalZombie.checkMobSpawnRules(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && blockPos.getY() <= 40 && (Boolean)CommonConfig.spawn_crystal_zombie.get() != false;
    }

    protected boolean convertsInWater() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedCrystalGoal());
        super.registerGoals();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 36.0).add(Attributes.MOVEMENT_SPEED, 0.05).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.KNOCKBACK_RESISTANCE, 2.0).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219165_, DifficultyInstance p_219166_) {
    }

    public class RangedCrystalGoal
    extends Goal {
        int cooldownTicks;
        int spikeDelay = 15;

        public boolean canUse() {
            LivingEntity livingentity = CrystalZombie.this.getTarget();
            return livingentity != null && livingentity.isAlive() && CrystalZombie.this.isAlive() && CrystalZombie.this.getSensing().hasLineOfSight((Entity)livingentity);
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = CrystalZombie.this.getTarget();
            return livingentity != null && livingentity.isAlive() && this.cooldownTicks >= -this.spikeDelay && CrystalZombie.this.isAlive();
        }

        public void start() {
            this.cooldownTicks = 60;
        }

        public void tick() {
            LivingEntity target = CrystalZombie.this.getTarget();
            --this.cooldownTicks;
            if (this.cooldownTicks == 0) {
                for (int i = 0; i <= 2; ++i) {
                    Vec3 targetPos = target.position();
                    double d0 = Math.min(targetPos.y(), CrystalZombie.this.getY());
                    double d1 = Math.max(targetPos.y(), CrystalZombie.this.getY()) + 1.0;
                    float f = (float)Mth.atan2((double)(targetPos.z() - CrystalZombie.this.getZ()), (double)(targetPos.x() - CrystalZombie.this.getX()));
                    this.createSpellEntity(targetPos.x + (double)new Random().nextFloat(), targetPos.z + (double)new Random().nextFloat(), d0, d1, f, 0);
                    CrystalZombie.this.playSound(SoundEvents.EVOKER_CAST_SPELL);
                    CrystalZombie.this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, CrystalZombie.this.position().x, CrystalZombie.this.position().y + 1.5, CrystalZombie.this.position().z, 0.0, 0.0, 0.0);
                    CrystalZombie.this.swing(InteractionHand.MAIN_HAND);
                }
                this.stop();
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = new BlockPos((int)p_32673_, (int)p_32676_, (int)p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = CrystalZombie.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)CrystalZombie.this.level(), blockpos1, Direction.UP)) continue;
                if (!CrystalZombie.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = CrystalZombie.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)CrystalZombie.this.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
            if (flag) {
                CrystalZombie.this.level().addFreshEntity((Entity)new SpikeCountdown(CrystalZombie.this.level(), 3.0f, p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)CrystalZombie.this, this.spikeDelay));
            }
        }
    }
}

