/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.equipment.armour;

import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class DarkArmourModel<T extends LivingEntity>
extends HumanoidArmorModel<T> {
    private final ModelPart cloak;

    public DarkArmourModel(ModelPart root) {
        super(root);
        this.cloak = this.body.getChild("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.75f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.getChild("head");
        PartDefinition hat = partdefinition.getChild("hat");
        PartDefinition body = partdefinition.getChild("body");
        PartDefinition right_arm = partdefinition.getChild("right_arm");
        PartDefinition left_arm = partdefinition.getChild("left_arm");
        PartDefinition right_leg = partdefinition.getChild("right_leg");
        PartDefinition left_leg = partdefinition.getChild("left_leg");
        PartDefinition crest = head.addOrReplaceChild("crest", CubeListBuilder.create().texOffs(32, 60).addBox(-1.0f, -10.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 40).addBox(0.0f, -20.0f, -6.0f, 0.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition cloak = body.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(0, 47).addBox(-4.0f, -0.5f, -0.25f, 8.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition right_arm_spikes = right_arm.addOrReplaceChild("right_arm_spikes", CubeListBuilder.create().texOffs(24, 49).mirror().addBox(-6.75f, -6.5f, 0.0f, 7.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_spikes = left_arm.addOrReplaceChild("left_arm_spikes", CubeListBuilder.create().texOffs(24, 49).addBox(-0.25f, -6.5f, 0.0f, 7.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float xRot0 = this.cloak.xRot;
        float xRotWanted = (15.0f - (float)(15.0 * Math.cos((double)ageInTicks * 0.15))) * ((float)Math.PI / 180);
        Float f = Float.valueOf(Math.min(1.25f, Math.abs(limbSwingAmount)));
        Float f1 = Float.valueOf(Math.min(1.25f, Math.abs(limbSwing)));
        f = Float.valueOf(Math.abs(limbSwingAmount));
        f1 = Float.valueOf(Math.abs(limbSwing));
        this.cloak.xRot = xRotWanted = Math.min(60.0f, 270.0f * f1.floatValue()) * ((float)Math.PI / 180) + (10.0f - (float)((double)(12.0f + 10.0f * f.floatValue()) * Math.cos((double)ageInTicks * 0.17))) * ((float)Math.PI / 180);
    }
}

