/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.eyeball;

import com.mojang.blaze3d.vertex.PoseStack;
import github.nitespring.monsterplus.ClientListener;
import github.nitespring.monsterplus.client.render.entities.mobs.eyeball.DemonEyeIrisLayer;
import github.nitespring.monsterplus.client.render.entities.mobs.eyeball.DemonEyeModel;
import github.nitespring.monsterplus.client.render.entities.mobs.eyeball.DemonEyeOverlayLayer;
import github.nitespring.monsterplus.common.entity.DemonEye;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class DemonEyeRenderer<T extends DemonEye>
extends MobRenderer<T, DemonEyeModel<T>> {
    public static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_translucent.png");
    public static final ResourceLocation RED = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_red.png");
    public static final ResourceLocation PURPLE = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_purple.png");
    public static final ResourceLocation GREEN = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_green.png");
    public static final ResourceLocation YELLOW = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_yellow.png");
    public static final ResourceLocation BLUE = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_blue.png");
    public static final ResourceLocation TEETH_OPEN = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_teeth.png");
    public static final ResourceLocation TEETH_CLOSED = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/demon_eye/demon_eye_teeth_closed.png");

    public DemonEyeRenderer(EntityRendererProvider.Context context) {
        super(context, new DemonEyeModel(context.bakeLayer(ClientListener.DEMON_EYE_LAYER)), 0.75f);
        this.addLayer(new DemonEyeIrisLayer(this, context.getModelSet()));
        this.addLayer(new DemonEyeOverlayLayer(this, context.getModelSet()));
    }

    public DemonEyeRenderer(EntityRendererProvider.Context context, DemonEyeModel<T> e, float f) {
        super(context, e, f);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.scale(((DemonEye)((Object)pEntity)).getDimensionScale(), ((DemonEye)((Object)pEntity)).getDimensionScale(), ((DemonEye)((Object)pEntity)).getDimensionScale());
        super.render(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(T e) {
        switch (((DemonEye)((Object)e)).getEyeType()) {
            case 1: {
                return PURPLE;
            }
            case 2: {
                return GREEN;
            }
            case 3: {
                return YELLOW;
            }
            case 4: {
                return BLUE;
            }
            case 5: {
                return ((DemonEye)((Object)e)).getAnimationState() == 1 ? TEETH_CLOSED : TEETH_OPEN;
            }
        }
        return RED;
    }

    protected int getBlockLightLevel(T e, BlockPos pos) {
        return Math.max(super.getBlockLightLevel(e, pos), 3);
    }

    protected float getShadowRadius(T pEntity) {
        return super.getShadowRadius(pEntity) * ((DemonEye)((Object)pEntity)).getDimensionScale();
    }
}

