/*
 * Decompiled with CFR 0.152.
 */
package github.nitespring.monsterplus.client.render.entities.mobs.abyssologer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import github.nitespring.monsterplus.ClientListener;
import github.nitespring.monsterplus.client.render.entities.mobs.abyssologer.CrystalSpikesModel;
import github.nitespring.monsterplus.common.entity.projectiles.CrystalSpikes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class CrystalSpikesRenderer<T extends CrystalSpikes>
extends EntityRenderer<T> {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"monsterplus", (String)"textures/entities/crystal_spike.png");
    private final CrystalSpikesModel<CrystalSpikes> model;

    public CrystalSpikesRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CrystalSpikesModel(context.bakeLayer(ClientListener.SPIKES_LAYER));
    }

    public void render(T entity, float p_114529_, float p_114530_, PoseStack stack, MultiBufferSource p_114532_, int p_114533_) {
        float f = ((CrystalSpikes)((Object)entity)).getAnimationProgress(p_114530_);
        if (f != 0.0f) {
            float f1 = 2.0f;
            if (f > 0.9f) {
                f1 *= (1.0f - f) / 0.1f;
            }
            stack.pushPose();
            stack.scale(0.75f, 0.75f, 0.75f);
            stack.scale(-f1, -f1, f1);
            stack.mulPose(Axis.XP.rotationDegrees((float)((CrystalSpikes)((Object)entity)).xTilt));
            stack.mulPose(Axis.ZP.rotationDegrees((float)((CrystalSpikes)((Object)entity)).zTilt));
            this.model.setupAnim((CrystalSpikes)((Object)entity), f, 0.0f, 0.0f, entity.getYRot(), entity.getXRot());
            VertexConsumer vertexconsumer = p_114532_.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_LOCATION));
            this.model.renderToBuffer(stack, vertexconsumer, p_114533_, OverlayTexture.NO_OVERLAY, -1);
            stack.popPose();
            super.render(entity, p_114529_, p_114530_, stack, p_114532_, p_114533_);
        }
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return TEXTURE_LOCATION;
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        return 10;
    }
}

