/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.util;

import java.util.function.Function;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class RegistryUtilities {
    public static void addToCreativeTabAfter(BuildCreativeModeTabContentsEvent event, Item after, Item ... toAdd) {
        if (toAdd.length > 0) {
            event.insertAfter(new ItemStack((ItemLike)after), new ItemStack((ItemLike)toAdd[0]), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            if (toAdd.length > 1) {
                for (int i = 1; i < toAdd.length; ++i) {
                    event.insertAfter(new ItemStack((ItemLike)toAdd[i - 1]), new ItemStack((ItemLike)toAdd[i]), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        }
    }

    public static <T extends Mob, R extends LivingEntityRenderer<T, M>, M extends PiglinModel<T>> void addLayerToRenderer(EntityRenderersEvent.AddLayers event, EntityType<T> entityType, Function<R, ? extends RenderLayer<T, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getRenderer(entityType);
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }
}

