/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class CodeUtilities {
    public static <T> T castOrNull(Object object, Class<T> castType) {
        return castType.isInstance(object) ? (T)castType.cast(object) : null;
    }

    public static <T> T castOrThrow(Object object) {
        return (T)object;
    }

    public static String snakeCaseToEnglish(String raw) {
        String[] parts = raw.split("_");
        StringBuilder output = new StringBuilder();
        for (String s : parts) {
            output.append(s.substring(0, 1).toUpperCase());
            output.append(s.substring(1));
            output.append(" ");
        }
        return output.toString().trim();
    }

    public static <T> List<T> castElementsToList(Object ... elements) {
        try {
            ArrayList list = new ArrayList();
            Collections.addAll(list, elements);
            return list;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot cast the input list to the output type! If you are a player, report to the Piglin Proliferation github");
        }
    }

    public static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static int capToRange(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double capToRange(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double ticksToSeconds(int ticks) {
        return CodeUtilities.round((float)ticks / 20.0f, 2);
    }

    public static String doubleToString(double value) {
        return value % 1.0 == 0.0 ? Integer.toString((int)value) : Double.toString(value);
    }

    public static <T> boolean compareOptionalHolders(Optional<Holder<T>> holder1, Optional<Holder<T>> holder2) {
        if (holder1.isPresent() && holder2.isPresent()) {
            return holder1.get().value().equals(holder2.get().value());
        }
        return false;
    }

    public static PotionContents potionContents(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

