/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.mixins;

import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightArm;

    @Inject(at={@At(value="TAIL")}, method={"setupAnim"})
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
            this.bucklerAnimationsRightArm(InteractionHand.MAIN_HAND, entityIn);
            this.bucklerAnimationsLeftArm(InteractionHand.OFF_HAND, entityIn);
        } else {
            this.bucklerAnimationsLeftArm(InteractionHand.MAIN_HAND, entityIn);
            this.bucklerAnimationsRightArm(InteractionHand.OFF_HAND, entityIn);
        }
    }

    public void bucklerAnimationsLeftArm(InteractionHand hand, T entityIn) {
        if (entityIn.getUsedItemHand() == hand && entityIn.getItemInHand(entityIn.getUsedItemHand()).getItem() instanceof BucklerItem) {
            float useDuration = entityIn.getItemInHand(entityIn.getUsedItemHand()).getUseDuration(entityIn);
            float useDurationClamped = Mth.clamp((float)entityIn.getTicksUsingItem(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.leftArm.yRot = Mth.lerp((float)result, (float)this.leftArm.yRot, (float)1.1466813f);
            this.leftArm.xRot = Mth.lerp((float)result, (float)this.leftArm.xRot, (float)(this.leftArm.xRot * 0.1f - 1.5f));
        }
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) > 0 && BucklerItem.isReady(entityIn.getItemInHand(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == InteractionHand.MAIN_HAND ? entityIn.getOffhandItem() : entityIn.getMainHandItem();
            if (!handItems.isEmpty()) {
                this.rightArm.xRot = -2.0132742f;
                this.rightArm.yRot = 0.5235988f;
            }
            this.leftArm.xRot = this.leftArm.xRot * 0.1f - 1.5f;
            this.leftArm.yRot = 1.1466813f;
        }
    }

    public void bucklerAnimationsRightArm(InteractionHand hand, T entityIn) {
        if (entityIn.getUsedItemHand() == hand && entityIn.getItemInHand(entityIn.getUsedItemHand()).getItem() instanceof BucklerItem) {
            float useDuration = entityIn.getItemInHand(entityIn.getUsedItemHand()).getUseDuration(entityIn);
            float useDurationClamped = Mth.clamp((float)entityIn.getTicksUsingItem(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.rightArm.yRot = Mth.lerp((float)result, (float)this.rightArm.yRot, (float)-1.1466813f);
            this.rightArm.xRot = Mth.lerp((float)result, (float)this.rightArm.xRot, (float)(this.rightArm.xRot * 0.1f - 1.5f));
        }
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) > 0 && BucklerItem.isReady(entityIn.getItemInHand(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == InteractionHand.MAIN_HAND ? entityIn.getOffhandItem() : entityIn.getMainHandItem();
            if (!handItems.isEmpty()) {
                this.leftArm.xRot = -2.0132742f;
                this.leftArm.yRot = -0.5235988f;
            }
            this.rightArm.xRot = -1.5f;
            this.rightArm.yRot = -1.1466813f;
        }
    }
}

