/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.loot;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.fml.ModList;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.common.items.TravelersCompassItem;
import tallestred.piglinproliferation.common.loot.PPLoot;
import tallestred.piglinproliferation.common.tags.EitherTag;
import tallestred.piglinproliferation.common.tags.PPTags;

public class CompassCanFindLocationCondition
implements LootItemCondition {
    public static final MapCodec<CompassCanFindLocationCondition> CODEC = MapCodec.unit((Object)new CompassCanFindLocationCondition());
    private static final Set<Either<Holder<Biome>, Holder<Structure>>> FINDABLE_SEARCH_OBJECTS = new HashSet<Either<Holder<Biome>, Holder<Structure>>>();

    public LootItemConditionType getType() {
        return (LootItemConditionType)PPLoot.COMPASS_CAN_FIND_LOCATION.get();
    }

    public boolean test(LootContext lootContext) {
        Object object = lootContext.getParam(LootContextParams.THIS_ENTITY);
        if (object instanceof PiglinTraveler) {
            PiglinTraveler traveler = (PiglinTraveler)((Object)object);
            ServerLevel level = lootContext.getLevel();
            List<Either<Holder<Biome>, Holder<Structure>>> objectsToSearch = CompassCanFindLocationCondition.searchObjects(level);
            Collections.shuffle(objectsToSearch);
            for (Either<Holder<Biome>, Holder<Structure>> searchObject : objectsToSearch) {
                Optional<BlockPos> pos;
                EitherTag.Location searchObjectLocation = EitherTag.elementLocation(searchObject);
                if (searchObjectLocation == null || traveler.alreadyLocatedObjects.containsKey(searchObjectLocation) || ((TravelersCompassItem)((Object)PPItems.TRAVELERS_COMPASS.get())).entityAtSearchObject(searchObject, (LivingEntity)traveler) || !(pos = ((TravelersCompassItem)((Object)PPItems.TRAVELERS_COMPASS.get())).search(searchObject, traveler.getOnPos(), level)).isPresent()) continue;
                traveler.currentlyLocatedObject = Map.entry(searchObjectLocation, pos.get());
                return true;
            }
        }
        return false;
    }

    private static List<Either<Holder<Biome>, Holder<Structure>>> searchObjects(ServerLevel level) {
        if (FINDABLE_SEARCH_OBJECTS.isEmpty()) {
            Set possibleBiomes = level.getChunkSource().getGenerator().getBiomeSource().possibleBiomes();
            for (Holder<Biome> biome : PPTags.TRAVELERS_COMPASS_SEARCH.leftValues(level.registryAccess())) {
                if (!possibleBiomes.contains(biome)) continue;
                FINDABLE_SEARCH_OBJECTS.add((Either<Holder<Biome>, Holder<Structure>>)Either.left(biome));
            }
            Set possibleStructures = level.getChunkSource().getGeneratorState().possibleStructureSets().stream().flatMap(set -> ((StructureSet)set.value()).structures().stream().map(StructureSet.StructureSelectionEntry::structure)).collect(Collectors.toSet());
            for (Holder<Structure> structure : PPTags.TRAVELERS_COMPASS_SEARCH.rightValues(level.registryAccess())) {
                if (!possibleStructures.contains(structure) || structure.is(BuiltinStructures.FORTRESS) && ModList.get().isLoaded("betterfortresses")) continue;
                FINDABLE_SEARCH_OBJECTS.add((Either<Holder<Biome>, Holder<Structure>>)Either.right(structure));
            }
        }
        return new ArrayList<Either<Holder<Biome>, Holder<Structure>>>(FINDABLE_SEARCH_OBJECTS);
    }

    public static void clearSearchCache() {
        FINDABLE_SEARCH_OBJECTS.clear();
    }
}

