/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.spawns;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;
import tallestred.piglinproliferation.common.tags.PPTags;

public class TravelerSpawner {
    public static int INITIAL_DELAY = 12000;
    public static int SPAWN_CHANCE_PERCENT = 25;
    public static MobSpawnType SPAWN_TYPE = MobSpawnType.NATURAL;
    public static int MAX_DISTANCE_FROM_PLAYER = 48;

    public static void tick(ServerLevel level, SpawnDelay spawnDelay) {
        --spawnDelay.timeRemaining;
        if (spawnDelay.timeRemaining <= 0) {
            spawnDelay.timeRemaining = INITIAL_DELAY;
            if (level.random.nextInt(100) <= SPAWN_CHANCE_PERCENT) {
                TravelerSpawner.spawn(level);
            }
        }
        spawnDelay.setDirty();
    }

    private static void spawn(ServerLevel level) {
        PiglinTraveler traveler;
        BlockPos pos;
        ServerPlayer player = TravelerSpawner.getRandomPlayer(level);
        if (player != null && !level.getBiome(player.blockPosition()).is(PPTags.WITHOUT_TRAVELER_SPAWNS) && (pos = TravelerSpawner.findSpawnPositionNear(level, player.blockPosition(), MAX_DISTANCE_FROM_PLAYER)) != null && !level.getBiome(pos).is(PPTags.WITHOUT_TRAVELER_SPAWNS) && (traveler = (PiglinTraveler)((EntityType)PPEntityTypes.PIGLIN_TRAVELER.get()).spawn(level, pos, SPAWN_TYPE)) != null) {
            traveler.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), SPAWN_TYPE, null);
        }
    }

    private static ServerPlayer getRandomPlayer(ServerLevel level) {
        List list = level.getPlayers(player -> player.isAlive() && !player.isSpectator());
        return list.isEmpty() ? null : (ServerPlayer)list.get(level.random.nextInt(list.size()));
    }

    @Nullable
    private static BlockPos findSpawnPositionNear(ServerLevel level, BlockPos pos, int maxDistance) {
        BlockPos outputPos = null;
        SpawnPlacementType spawnPlacement = SpawnPlacements.getPlacementType((EntityType)((EntityType)PPEntityTypes.PIGLIN_TRAVELER.get()));
        for (int i = 0; i < 10; ++i) {
            int x = pos.getX() + level.random.nextInt(maxDistance * 2) - maxDistance;
            int z = pos.getZ() + level.random.nextInt(maxDistance * 2) - maxDistance;
            BlockPos testPos = NaturalSpawner.getTopNonCollidingPos((LevelReader)level, (EntityType)((EntityType)PPEntityTypes.PIGLIN_TRAVELER.get()), (int)x, (int)z);
            if (!spawnPlacement.isSpawnPositionOk((LevelReader)level, testPos, (EntityType)PPEntityTypes.PIGLIN_TRAVELER.get())) continue;
            outputPos = testPos;
            break;
        }
        return outputPos == null ? null : outputPos.above();
    }

    public static class SpawnDelay
    extends SavedData {
        private int timeRemaining = INITIAL_DELAY;

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            tag.putInt("TravelerSpawnDelay", this.timeRemaining);
            return tag;
        }

        public static SpawnDelay load(CompoundTag tag, HolderLookup.Provider provider) {
            SpawnDelay delay = new SpawnDelay();
            delay.timeRemaining = tag.getInt("TravelerSpawnDelay");
            return delay;
        }

        public static SavedData.Factory<SpawnDelay> factory() {
            return new SavedData.Factory(SpawnDelay::new, SpawnDelay::load, null);
        }
    }
}

