/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.goals;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import tallestred.piglinproliferation.common.enchantments.PPEnchantments;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;
import tallestred.piglinproliferation.configuration.PPConfig;

public class UseBucklerGoal<T extends PathfinderMob>
extends Goal {
    private final T owner;
    private int strafeTicks;
    private long nextOkStartTime;
    private ChargePhases chargePhase = ChargePhases.NONE;

    public UseBucklerGoal(T owner) {
        this.owner = owner;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.owner.level().getGameTime() - this.nextOkStartTime > (long)((Integer)PPConfig.COMMON.bucklerCooldown.get()).intValue() && this.owner.getOffhandItem().getItem() instanceof BucklerItem && this.owner.getTarget() != null && this.owner.hasLineOfSight((Entity)this.owner.getTarget()) && (double)this.owner.getTarget().distanceTo(this.owner) >= 4.0 && !this.owner.isInWaterRainOrBubble();
    }

    public boolean canContinueToUse() {
        return this.owner.getOffhandItem().getItem() instanceof BucklerItem && this.owner.getTarget() != null && this.owner.hasLineOfSight((Entity)this.owner.getTarget()) && !this.owner.isInWaterRainOrBubble() && this.chargePhase != ChargePhases.FINISH;
    }

    public void tick() {
        LivingEntity livingEntity = this.owner.getTarget();
        if (livingEntity == null) {
            return;
        }
        if ((double)this.owner.distanceTo((Entity)livingEntity) >= 10.0) {
            this.owner.getNavigation().moveTo((Entity)livingEntity, 1.0);
        } else {
            this.owner.getNavigation().stop();
        }
        if (this.chargePhase == ChargePhases.STRAFE && this.strafeTicks > 0 && (double)this.owner.distanceTo((Entity)livingEntity) >= 4.0 && (double)this.owner.distanceTo((Entity)livingEntity) <= 10.0) {
            this.owner.getMoveControl().strafe(-2.0f, 0.0f);
            --this.strafeTicks;
            if (this.strafeTicks == 0) {
                this.chargePhase = ChargePhases.CHARGE;
            }
            if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) > 0 && PPEnchantments.getBucklerEnchantsOnHands(PPEnchantments.TURNING, this.owner) > 0 || BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) <= 0) {
                this.owner.lookAt((Entity)livingEntity, 30.0f, 30.0f);
            }
        } else if (this.chargePhase == ChargePhases.CHARGE) {
            if (!this.owner.isUsingItem() && BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) <= 0) {
                this.owner.startUsingItem(InteractionHand.OFF_HAND);
            }
            if (this.owner.getTicksUsingItem() >= this.owner.getUseItem().getUseDuration(this.owner)) {
                this.chargePhase = ChargePhases.CHARGING;
            }
        } else if (this.chargePhase == ChargePhases.CHARGING && BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(this.owner)) <= 0) {
            this.chargePhase = ChargePhases.FINISH;
        }
    }

    public void start() {
        this.owner.setAggressive(true);
        this.chargePhase = ChargePhases.STRAFE;
        this.strafeTicks = 20;
    }

    public void stop() {
        if (this.owner.isUsingItem()) {
            this.owner.stopUsingItem();
        }
        this.owner.setAggressive(false);
        this.owner.setTarget(null);
        this.nextOkStartTime = this.owner.level().getGameTime();
    }

    public static enum ChargePhases {
        NONE,
        STRAFE,
        CHARGE,
        CHARGING,
        FINISH;

    }
}

