/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class PiglinCallForHelpGoal
extends Goal {
    protected final Predicate<? super AbstractPiglin> nearbyPiglinPredicate;
    protected final Predicate<? super PiglinAlchemist> alchemistPredicate;
    private final AbstractPiglin piglin;
    private PiglinAlchemist alchemist;

    public PiglinCallForHelpGoal(AbstractPiglin abstractPiglin, Predicate<? super AbstractPiglin> nearbyPiglinPredicate, Predicate<? super PiglinAlchemist> alchemistPredicate) {
        this.piglin = abstractPiglin;
        this.nearbyPiglinPredicate = nearbyPiglinPredicate;
        this.alchemistPredicate = alchemistPredicate;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List list = this.piglin.level().getEntitiesOfClass(PiglinAlchemist.class, this.piglin.getBoundingBox().inflate(15.0, 3.0, 15.0));
        if (!list.isEmpty()) {
            for (PiglinAlchemist alchemist : list) {
                if (!alchemist.isAlive() || alchemist == this.piglin) continue;
                this.alchemist = alchemist;
                return this.nearbyPiglinPredicate.test((AbstractPiglin)this.piglin) && this.alchemistPredicate.test(this.alchemist);
            }
        }
        return false;
    }

    public void tick() {
        WalkTarget walktarget = new WalkTarget((Entity)this.alchemist, 1.0f, 5);
        this.piglin.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)walktarget);
        this.piglin.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.alchemist, true));
    }

    public void stop() {
        this.piglin.getNavigation().stop();
    }
}

