/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.goals;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class DumbBowAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private int attackTime = -1;
    private int seeTime;

    public <M extends Monster> DumbBowAttackGoal(M pMob, double pSpeedModifier, int pAttackIntervalMin, float pAttackRadius) {
        this(pMob, pSpeedModifier, pAttackIntervalMin, pAttackRadius);
    }

    public DumbBowAttackGoal(T pMob, double pSpeedModifier, int pAttackIntervalMin, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.getTarget() == null ? false : this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.isHolding(is -> is.getItem() instanceof BowItem);
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingBow();
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.stopUsingItem();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            boolean flag1;
            double distance = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            boolean flag = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(distance > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier);
            }
            Entity entity = this.mob.getControlledVehicle();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                mob.getLookControl().setLookAt((Entity)livingentity);
            }
            this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
            this.mob.getLookControl().setLookAt((Entity)livingentity);
            this.mob.getNavigation().moveTo((Entity)livingentity, 1.0);
            if (this.mob.isUsingItem()) {
                int i;
                if (!flag && this.seeTime < -60) {
                    this.mob.stopUsingItem();
                } else if (flag && (i = this.mob.getTicksUsingItem()) >= 20) {
                    this.mob.stopUsingItem();
                    ItemStack itemstack = this.mob.getProjectile(this.mob.getItemInHand(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem)));
                    AbstractArrow abstractarrowentity = ProjectileUtil.getMobArrow(this.mob, (ItemStack)itemstack, (float)BowItem.getPowerForTime((int)i), (ItemStack)this.mob.getItemInHand(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem)));
                    double d0 = livingentity.getX() - this.mob.getX();
                    double d1 = livingentity.getY(0.3333333333333333) - abstractarrowentity.getY();
                    double d2 = livingentity.getZ() - this.mob.getZ();
                    double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                    abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.mob.level().getDifficulty().getId() * 4));
                    this.mob.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.mob.getRandom().nextFloat() * 0.4f + 0.8f));
                    this.mob.level().addFreshEntity((Entity)abstractarrowentity);
                    itemstack.shrink(1);
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
        }
    }
}

