/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;

public class TravelerSit<T extends PiglinTraveler>
extends Behavior<T> {
    public TravelerSit() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, T owner) {
        return owner.getNoActionTime() >= 60;
    }

    protected void tick(ServerLevel pLevel, T pOwner, long pGameTime) {
        super.tick(pLevel, pOwner, pGameTime);
        pOwner.getNavigation().stop();
        pOwner.getBrain().eraseMemory(MemoryModuleType.PATH);
    }

    protected boolean canStillUse(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        return ((PiglinTraveler)((Object)entityIn)).isSitting() && !entityIn.isAggressive() && !entityIn.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET);
    }

    protected void start(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        ((PiglinTraveler)((Object)entityIn)).sit(true);
    }

    protected void stop(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        ((PiglinTraveler)((Object)entityIn)).sit(false);
    }
}

