/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;

public class SafeCrossbowAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;

    public SafeCrossbowAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        LivingEntity livingentity = SafeCrossbowAttack.getAttackTarget(owner);
        return livingentity != null && owner.isHolding(is -> is.getItem() instanceof CrossbowItem) && BehaviorUtils.canSee(owner, (LivingEntity)livingentity) && BehaviorUtils.isWithinAttackRange(owner, (LivingEntity)livingentity, (int)0);
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        LivingEntity livingentity = SafeCrossbowAttack.getAttackTarget(entity);
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && livingentity != null && this.checkExtraStartConditions(level, entity);
    }

    protected void tick(ServerLevel level, E owner, long gameTime) {
        LivingEntity livingentity = SafeCrossbowAttack.getAttackTarget(owner);
        if (livingentity == null) {
            return;
        }
        this.lookAtTarget((Mob)owner, livingentity);
        this.crossbowAttack(owner, livingentity);
    }

    protected void stop(ServerLevel level, E entity, long gameTime) {
        if (entity.isUsingItem()) {
            entity.stopUsingItem();
        }
        if (entity.isHolding(is -> is.getItem() instanceof CrossbowItem)) {
            ((CrossbowAttackMob)entity).setChargingCrossbow(false);
            entity.getUseItem().set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        }
    }

    private void crossbowAttack(E shooter, LivingEntity target) {
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            shooter.startUsingItem(ProjectileUtil.getWeaponHoldingHand(shooter, item -> item instanceof CrossbowItem));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)shooter).setChargingCrossbow(true);
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemstack;
            int i;
            if (!shooter.isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = shooter.getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(itemstack = shooter.getUseItem()), shooter)) {
                shooter.releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + shooter.getRandom().nextInt(20);
                ((CrossbowAttackMob)shooter).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK) {
            ((RangedAttackMob)shooter).performRangedAttack(target, 1.0f);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void lookAtTarget(Mob shooter, LivingEntity target) {
        shooter.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity shooter) {
        return shooter.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) ? (LivingEntity)shooter.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get() : null;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

