/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StartHuntingHoglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinTraveler;
import tallestred.piglinproliferation.common.entities.ai.AbstractPiglinAi;
import tallestred.piglinproliferation.common.entities.ai.behaviors.KickWhenClose;
import tallestred.piglinproliferation.common.entities.ai.behaviors.MoveAroundPiglins;
import tallestred.piglinproliferation.common.entities.ai.behaviors.StopHoldingItemAfterAdmiring;
import tallestred.piglinproliferation.common.entities.ai.behaviors.SwimOnlyOutOfLava;
import tallestred.piglinproliferation.common.entities.ai.behaviors.TravelerSit;
import tallestred.piglinproliferation.common.items.TravelersCompassItem;
import tallestred.piglinproliferation.common.loot.PPLoot;
import tallestred.piglinproliferation.util.CodeUtilities;

public class PiglinTravelerAi
extends AbstractPiglinAi<PiglinTraveler> {
    public static PiglinTravelerAi INSTANCE = new PiglinTravelerAi();

    @Override
    protected List<BehaviorControl<? super PiglinTraveler>> coreBehaviors(PiglinTraveler piglin) {
        return CodeUtilities.castElementsToList(new Object[]{new LookAtTargetSink(45, 90), new MoveToTargetSink(), InteractWithDoor.create(), new SwimOnlyOutOfLava(0.8f), StopHoldingItemAfterAdmiring.create(this, PPLoot.TRAVELER_BARTER), StartAdmiringItemIfSeen.create((int)120), StartCelebratingIfTargetDead.create((int)300, PiglinAi::wantsToDance), StopBeingAngryIfTargetDead.create()});
    }

    @Override
    protected List<BehaviorControl<? super PiglinTraveler>> idleBehaviors(PiglinTraveler piglin) {
        return CodeUtilities.castElementsToList(SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, (float)14.0f), StartAttacking.create(AbstractPiglin::isAdult, this::nearestValidAttackTarget), BehaviorBuilder.triggerIf(Piglin::canHunt, (OneShot)StartHuntingHoglin.create()), PiglinAi.babySometimesRideBabyHoglin(), this.idleLookBehaviors(), this.idleMovementBehaviors(), SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4));
    }

    @Override
    protected RunOne<PiglinTraveler> idleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(MoveAroundPiglins.moveAroundPiglins(0.6f, true), (Object)2), (Object)Pair.of(new TravelerSit(), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.PIGLIN, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(PiglinAi::doesntSeeAnyPlayerHoldingLovedItem, (OneShot)SetWalkTargetFromLookTarget.create((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)2, (int)100), (Object)2), (Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.6f, (int)5), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    @Override
    protected List<BehaviorControl<? super PiglinTraveler>> fightBehaviors(PiglinTraveler piglin) {
        List<BehaviorControl<? super PiglinTraveler>> list = super.fightBehaviors(piglin);
        list.add((BehaviorControl<? super PiglinTraveler>)KickWhenClose.create(2));
        return list;
    }

    @Override
    protected Optional<? extends LivingEntity> nearestValidAttackTarget(Piglin piglin) {
        Brain brain = piglin.getBrain();
        if (PiglinTravelerAi.isNearZombified((Piglin)piglin)) {
            return Optional.empty();
        }
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)piglin, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional<LivingEntity> fallbackOptional = PiglinTravelerAi.findNemesisTarget((Brain<? extends Piglin>)brain);
        if (fallbackOptional.isPresent()) {
            return fallbackOptional;
        }
        return Optional.empty();
    }

    @Override
    public void specificThrowItemBehaviour(PiglinTraveler piglin, ItemStack stack) {
        if (stack.getItem() instanceof TravelersCompassItem) {
            piglin.playBarteringAnimation();
            piglin.level().playSound(null, piglin.getX(), piglin.getY(), piglin.getZ(), (SoundEvent)PPSounds.MAKE_COMPASS.get(), piglin.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public SoundEvent soundForActivity(PiglinTraveler piglin, Activity activity) {
        if (activity == Activity.FIGHT) {
            return (SoundEvent)PPSounds.TRAVELER_ANGRY.get();
        }
        if (piglin.isConverting()) {
            return (SoundEvent)PPSounds.TRAVELER_RETREAT.get();
        }
        if (activity == Activity.AVOID && PiglinTravelerAi.isNearAvoidTarget((Piglin)piglin)) {
            return (SoundEvent)PPSounds.TRAVELER_RETREAT.get();
        }
        if (activity == Activity.ADMIRE_ITEM) {
            return (SoundEvent)PPSounds.TRAVELER_ADMIRE.get();
        }
        if (activity == Activity.CELEBRATE) {
            return (SoundEvent)PPSounds.TRAVELER_CELEBRATE.get();
        }
        if (PiglinTravelerAi.seesPlayerHoldingLovedItem((LivingEntity)piglin)) {
            return (SoundEvent)PPSounds.TRAVELER_JEALOUS.get();
        }
        return PiglinTravelerAi.isNearRepellent((Piglin)piglin) ? (SoundEvent)PPSounds.TRAVELER_RETREAT.get() : (SoundEvent)PPSounds.TRAVELER_IDLE.get();
    }
}

